/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractDisplay;
import org.aoju.bus.health.builtin.hardware.Display;
import org.aoju.bus.logger.Logger;

@Immutable
final class LinuxDisplay
extends AbstractDisplay {
    private static final String[] XRANDR_VERBOSE = new String[]{"xrandr", "--verbose"};

    LinuxDisplay(byte[] edid) {
        super(edid);
        Logger.debug("Initialized LinuxDisplay", new Object[0]);
    }

    public static List<Display> getDisplays() {
        List<String> xrandr = Executor.runNative(XRANDR_VERBOSE, null);
        if (xrandr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LinuxDisplay> displays = new ArrayList<LinuxDisplay>();
        StringBuilder sb = null;
        for (String s : xrandr) {
            if (s.contains("EDID")) {
                sb = new StringBuilder();
                continue;
            }
            if (sb == null) continue;
            sb.append(s.trim());
            if (sb.length() < 256) continue;
            String edidStr = sb.toString();
            Logger.debug("Parsed EDID: {}", edidStr);
            byte[] edid = Builder.hexStringToByteArray(edidStr);
            if (edid.length >= 128) {
                displays.add(new LinuxDisplay(edid));
            }
            sb = null;
        }
        return Collections.unmodifiableList(displays);
    }
}

