/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractHWDiskStore;
import org.aoju.bus.health.builtin.hardware.HWDiskStore;
import org.aoju.bus.health.builtin.hardware.HWPartition;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.PhysicalDisk;
import org.aoju.bus.health.windows.drivers.Win32DiskDrive;
import org.aoju.bus.health.windows.drivers.Win32DiskDriveToDiskPartition;
import org.aoju.bus.health.windows.drivers.Win32DiskPartition;
import org.aoju.bus.health.windows.drivers.Win32LogicalDiskToPartition;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class WindowsHWDiskStore
extends AbstractHWDiskStore {
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList;

    private WindowsHWDiskStore(String name, String model, String serial, long size) {
        super(name, model, serial, size);
    }

    public static List<HWDiskStore> getDisks() {
        ArrayList<WindowsHWDiskStore> result = new ArrayList<WindowsHWDiskStore>();
        DiskStats stats = WindowsHWDiskStore.queryReadWriteStats(null);
        PartitionMaps maps = WindowsHWDiskStore.queryPartitionMaps();
        WbemcliUtil.WmiResult<Win32DiskDrive.DiskDriveProperty> vals = Win32DiskDrive.queryDiskDrive();
        for (int i = 0; i < vals.getResultCount(); ++i) {
            WindowsHWDiskStore ds = new WindowsHWDiskStore(WmiKit.getString(vals, Win32DiskDrive.DiskDriveProperty.NAME, i), String.format("%s %s", WmiKit.getString(vals, Win32DiskDrive.DiskDriveProperty.MODEL, i), WmiKit.getString(vals, Win32DiskDrive.DiskDriveProperty.MANUFACTURER, i)).trim(), Builder.hexStringToString(WmiKit.getString(vals, Win32DiskDrive.DiskDriveProperty.SERIALNUMBER, i)), WmiKit.getUint64(vals, Win32DiskDrive.DiskDriveProperty.SIZE, i));
            String index = Integer.toString(WmiKit.getUint32(vals, Win32DiskDrive.DiskDriveProperty.INDEX, i));
            ds.reads = stats.readMap.getOrDefault(index, 0L);
            ds.readBytes = stats.readByteMap.getOrDefault(index, 0L);
            ds.writes = stats.writeMap.getOrDefault(index, 0L);
            ds.writeBytes = stats.writeByteMap.getOrDefault(index, 0L);
            ds.currentQueueLength = stats.queueLengthMap.getOrDefault(index, 0L);
            ds.transferTime = stats.timeStamp - stats.idleTimeMap.getOrDefault(index, stats.timeStamp);
            ds.timeStamp = stats.timeStamp;
            ArrayList partitions = new ArrayList();
            List partList = (List)maps.driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    if (!maps.partitionMap.containsKey(part)) continue;
                    partitions.addAll((Collection)maps.partitionMap.get(part));
                }
            }
            ds.partitionList = Collections.unmodifiableList(partitions.stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList()));
            result.add(ds);
        }
        return Collections.unmodifiableList(result);
    }

    private static DiskStats queryReadWriteStats(String index) {
        DiskStats stats = new DiskStats();
        Pair<List<String>, Map<PhysicalDisk.PhysicalDiskProperty, List<Long>>> instanceValuePair = PhysicalDisk.queryDiskCounters();
        List<String> instances = instanceValuePair.getLeft();
        Map<PhysicalDisk.PhysicalDiskProperty, List<Long>> valueMap = instanceValuePair.getRight();
        stats.timeStamp = System.currentTimeMillis();
        List<Long> readList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKREADSPERSEC);
        List<Long> readByteList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKREADBYTESPERSEC);
        List<Long> writeList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKWRITESPERSEC);
        List<Long> writeByteList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.DISKWRITEBYTESPERSEC);
        List<Long> queueLengthList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.CURRENTDISKQUEUELENGTH);
        List<Long> idleTimeList = valueMap.get(PhysicalDisk.PhysicalDiskProperty.PERCENTIDLETIME);
        if (instances.isEmpty() || readList == null || readByteList == null || writeList == null || writeByteList == null || queueLengthList == null || idleTimeList == null) {
            return stats;
        }
        for (int i = 0; i < instances.size(); ++i) {
            String name = WindowsHWDiskStore.getIndexFromName(instances.get(i));
            if (index != null && !index.equals(name)) continue;
            stats.readMap.put(name, readList.get(i));
            stats.readByteMap.put(name, readByteList.get(i));
            stats.writeMap.put(name, writeList.get(i));
            stats.writeByteMap.put(name, writeByteList.get(i));
            stats.queueLengthMap.put(name, queueLengthList.get(i));
            stats.idleTimeMap.put(name, idleTimeList.get(i) / 10000L);
        }
        return stats;
    }

    private static PartitionMaps queryPartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        PartitionMaps maps = new PartitionMaps();
        WbemcliUtil.WmiResult<Win32DiskDriveToDiskPartition.DriveToPartitionProperty> drivePartitionMap = Win32DiskDriveToDiskPartition.queryDriveToPartition();
        for (int i = 0; i < drivePartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiKit.getRefString(drivePartitionMap, Win32DiskDriveToDiskPartition.DriveToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiKit.getRefString(drivePartitionMap, Win32DiskDriveToDiskPartition.DriveToPartitionProperty.DEPENDENT, i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            maps.driveToPartitionMap.computeIfAbsent(mAnt.group(1).replace("\\\\", "\\"), x -> new ArrayList()).add(mDep.group(1));
        }
        WbemcliUtil.WmiResult<Win32LogicalDiskToPartition.DiskToPartitionProperty> diskPartitionMap = Win32LogicalDiskToPartition.queryDiskToPartition();
        for (int i = 0; i < diskPartitionMap.getResultCount(); ++i) {
            mAnt = DEVICE_ID.matcher(WmiKit.getRefString(diskPartitionMap, Win32LogicalDiskToPartition.DiskToPartitionProperty.ANTECEDENT, i));
            mDep = DEVICE_ID.matcher(WmiKit.getRefString(diskPartitionMap, Win32LogicalDiskToPartition.DiskToPartitionProperty.DEPENDENT, i));
            long size = WmiKit.getUint64(diskPartitionMap, Win32LogicalDiskToPartition.DiskToPartitionProperty.ENDINGADDRESS, i) - WmiKit.getUint64(diskPartitionMap, Win32LogicalDiskToPartition.DiskToPartitionProperty.STARTINGADDRESS, i) + 1L;
            if (!mAnt.matches() || !mDep.matches()) continue;
            if (maps.partitionToLogicalDriveMap.containsKey(mAnt.group(1))) {
                ((List)maps.partitionToLogicalDriveMap.get(mAnt.group(1))).add(Pair.of(mDep.group(1) + "\\", size));
                continue;
            }
            ArrayList<Pair<String, Long>> list = new ArrayList<Pair<String, Long>>();
            list.add(Pair.of(mDep.group(1) + "\\", size));
            maps.partitionToLogicalDriveMap.put(mAnt.group(1), list);
        }
        WbemcliUtil.WmiResult<Win32DiskPartition.DiskPartitionProperty> hwPartitionQueryMap = Win32DiskPartition.queryPartition();
        for (int i = 0; i < hwPartitionQueryMap.getResultCount(); ++i) {
            String deviceID = WmiKit.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.DEVICEID, i);
            List logicalDrives = (List)maps.partitionToLogicalDriveMap.get(deviceID);
            if (logicalDrives == null) continue;
            for (int j = 0; j < logicalDrives.size(); ++j) {
                Pair logicalDrive = (Pair)logicalDrives.get(j);
                if (logicalDrive == null || ((String)logicalDrive.getLeft()).isEmpty()) continue;
                HWPartition pt = new HWPartition(WmiKit.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.NAME, i), WmiKit.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.TYPE, i), WmiKit.getString(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.DESCRIPTION, i), "", (Long)logicalDrive.getRight(), WmiKit.getUint32(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.DISKINDEX, i), WmiKit.getUint32(hwPartitionQueryMap, Win32DiskPartition.DiskPartitionProperty.INDEX, i), (String)logicalDrive.getLeft());
                if (maps.partitionMap.containsKey(deviceID)) {
                    ((List)maps.partitionMap.get(deviceID)).add(pt);
                    continue;
                }
                ArrayList<HWPartition> ptlist = new ArrayList<HWPartition>();
                ptlist.add(pt);
                maps.partitionMap.put(deviceID, ptlist);
            }
        }
        return maps;
    }

    private static String getIndexFromName(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.split("\\s")[0];
    }

    @Override
    public long getReads() {
        return this.reads;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrites() {
        return this.writes;
    }

    @Override
    public long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    @Override
    public boolean updateAttributes() {
        String index;
        List<HWPartition> partitions = this.getPartitions();
        if (!partitions.isEmpty()) {
            index = Integer.toString(partitions.get(0).getMajor());
        } else if (this.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = this.getName().substring(PHYSICALDRIVE_PREFIX.length(), this.getName().length());
        } else {
            Logger.warn("Couldn't match index for {}", this.getName());
            return false;
        }
        DiskStats stats = WindowsHWDiskStore.queryReadWriteStats(index);
        if (stats.readMap.containsKey(index)) {
            this.reads = stats.readMap.getOrDefault(index, 0L);
            this.readBytes = stats.readByteMap.getOrDefault(index, 0L);
            this.writes = stats.writeMap.getOrDefault(index, 0L);
            this.writeBytes = stats.writeByteMap.getOrDefault(index, 0L);
            this.currentQueueLength = stats.queueLengthMap.getOrDefault(index, 0L);
            this.transferTime = stats.timeStamp - stats.idleTimeMap.getOrDefault(index, stats.timeStamp);
            this.timeStamp = stats.timeStamp;
            return true;
        }
        return false;
    }

    private static final class PartitionMaps {
        private final Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
        private final Map<String, List<Pair<String, Long>>> partitionToLogicalDriveMap = new HashMap<String, List<Pair<String, Long>>>();
        private final Map<String, List<HWPartition>> partitionMap = new HashMap<String, List<HWPartition>>();

        private PartitionMaps() {
        }
    }

    private static final class DiskStats {
        private final Map<String, Long> readMap = new HashMap<String, Long>();
        private final Map<String, Long> readByteMap = new HashMap<String, Long>();
        private final Map<String, Long> writeMap = new HashMap<String, Long>();
        private final Map<String, Long> writeByteMap = new HashMap<String, Long>();
        private final Map<String, Long> queueLengthMap = new HashMap<String, Long>();
        private final Map<String, Long> idleTimeMap = new HashMap<String, Long>();
        private long timeStamp;

        private DiskStats() {
        }
    }
}

