/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Process;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Toable;
import org.aoju.bus.http.magic.RealResult;
import org.aoju.bus.http.metric.Download;
import org.aoju.bus.http.metric.TaskExecutor;

public interface Results {
    public static Results of(Response response) {
        return Results.of(response, null);
    }

    public static Results of(Response response, TaskExecutor taskExecutor) {
        if (response != null) {
            return new RealResult(null, response, taskExecutor);
        }
        throw new IllegalArgumentException("Response cannot be empty!");
    }

    public State getState();

    public int getStatus();

    public boolean isSuccessful();

    public Headers getHeaders();

    public List<String> getHeaders(String var1);

    public String getHeader(String var1);

    public long getContentLength();

    public Body getBody();

    public IOException getError();

    public Results close();

    public static interface Body
    extends Toable {
        public MediaType getType();

        public long getLength();

        public Body nextOnIO();

        public Body setOnProcess(OnBack<Process> var1);

        public Body stepBytes(long var1);

        public Body stepRate(double var1);

        public Body setRangeIgnored();

        public Download toFile(String var1);

        public Download toFile(File var1);

        public Download toFolder(String var1);

        public Download toFolder(File var1);

        public Body cache();

        public Body close();
    }

    public static enum State {
        EXCEPTION,
        CANCELED,
        RESPONSED,
        TIMEOUT,
        NETWORK_ERROR;

    }
}

