/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.bodys.FormBody;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.magic.HttpRequest;
import org.aoju.bus.http.magic.PostRequest;

public class PutRequest
extends HttpRequest {
    public PutRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<PostRequest.FileInfo> fileInfos, String body, MultipartBody multipartBody, int id) {
        super(url, tag, params, headers, fileInfos, body, multipartBody, id);
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.multipartBody != null) {
            return this.multipartBody;
        }
        if (this.fileInfos != null && this.fileInfos.size() > 0) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE);
            this.addParams(builder);
            this.fileInfos.forEach(fileInfo -> {
                RequestBody fileBody = fileInfo.file != null ? RequestBody.create(MediaType.APPLICATION_OCTET_STREAM_TYPE, fileInfo.file) : (fileInfo.fileInputStream != null ? PutRequest.createRequestBody(MediaType.APPLICATION_OCTET_STREAM_TYPE, fileInfo.fileInputStream) : RequestBody.create(MediaType.valueOf(FileKit.getMimeType(fileInfo.fileName)), fileInfo.fileContent));
                builder.addFormDataPart(fileInfo.partName, fileInfo.fileName, fileBody);
            });
            if (this.body != null && this.body.length() > 0) {
                builder.addPart(RequestBody.create(MediaType.MULTIPART_FORM_DATA_TYPE, this.body));
            }
            return builder.build();
        }
        if (this.body != null && this.body.length() > 0) {
            MediaType mediaType = this.headers.containsKey("Content-Type") ? MediaType.valueOf((String)this.headers.get("Content-Type")) : MediaType.TEXT_PLAIN_TYPE;
            return RequestBody.create(mediaType, this.body);
        }
        FormBody.Builder builder = new FormBody.Builder();
        this.addParams(builder);
        return builder.build();
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.put(requestBody).build();
    }

    private void addParams(FormBody.Builder builder) {
        if (this.params != null) {
            this.params.forEach((k, v) -> builder.add((String)k, (String)v));
        }
        if (this.encodedParams != null) {
            this.encodedParams.forEach((k, v) -> builder.addEncoded((String)k, (String)v));
        }
    }

    private void addParams(MultipartBody.Builder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            this.params.forEach((k, v) -> builder.addPart(Headers.of("Content-Disposition", "form-data; name=" + k + "\""), RequestBody.create(null, v)));
        }
    }
}

