/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.generic;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.notify.magic.Property;

public class NativeDmProperty
extends Property {
    private static final String SMTP_HOST = "mail.smtp.host";
    private static final String SMTP_PORT = "mail.smtp.port";
    private static final String SMTP_AUTH = "mail.smtp.auth";
    private static final String SMTP_TIMEOUT = "mail.smtp.timeout";
    private static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String SOCKEY_FACTORY = "mail.smtp.socketFactory.class";
    private static final String SOCKEY_FACTORY_PORT = "smtp.socketFactory.port";
    private static final String SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    private static final String MAIL_TLS_ENABLE = "mail.smtp.starttls.enable";
    private static final String MAIL_PROTOCOL = "mail.transport.protocol";
    private static final String SPLIT_LONG_PARAMS = "mail.mime.splitlongparameters";
    private static final String MAIL_DEBUG = "mail.debug";
    private String host;
    private Integer port;
    private Boolean auth;
    private String user;
    private String pass;
    private boolean debug;
    private java.nio.charset.Charset charset;
    private boolean splitlongparameters;
    private boolean startttlsEnable;
    private Boolean sslEnable;
    private String socketFactoryClass = "javax.net.ssl.SSLSocketFactory";
    private boolean socketFactoryFallback;
    private int socketFactoryPort = 465;
    private long timeout;
    private long connectionTimeout;
    private String ccs;
    private String bccs;
    private String title;
    private String content;
    private File[] attachments;
    private boolean useGlobalSession;

    public NativeDmProperty defaultIfEmpty() {
        if (StringKit.isBlank(this.host)) {
            this.host = StringKit.format("smtp.{}", StringKit.subSuf(this.sender, this.sender.indexOf(64) + 1));
        }
        if (StringKit.isBlank(this.user)) {
            this.user = StringKit.subPre(this.sender, this.sender.indexOf(64));
        }
        if (null == this.auth) {
            this.auth = false == StringKit.isBlank(this.pass);
        }
        if (null == this.port) {
            this.port = null != this.sslEnable && this.sslEnable != false ? this.socketFactoryPort : 25;
        }
        if (null == this.charset) {
            this.charset = Charset.UTF_8;
        }
        return this;
    }

    public Properties getSmtpProps() {
        System.setProperty(SPLIT_LONG_PARAMS, String.valueOf(this.splitlongparameters));
        Properties p = new Properties();
        p.put(MAIL_PROTOCOL, "smtp");
        p.put(SMTP_HOST, this.host);
        p.put(SMTP_PORT, String.valueOf(this.port));
        p.put(SMTP_AUTH, String.valueOf(this.auth));
        if (this.timeout > 0L) {
            p.put(SMTP_TIMEOUT, String.valueOf(this.timeout));
        }
        if (this.connectionTimeout > 0L) {
            p.put(SMTP_CONNECTION_TIMEOUT, String.valueOf(this.connectionTimeout));
        }
        p.put(MAIL_DEBUG, String.valueOf(this.debug));
        if (this.startttlsEnable) {
            p.put(MAIL_TLS_ENABLE, String.valueOf(this.startttlsEnable));
            if (null == this.sslEnable) {
                this.sslEnable = true;
            }
        }
        if (null != this.sslEnable && this.sslEnable.booleanValue()) {
            p.put(SOCKEY_FACTORY, this.socketFactoryClass);
            p.put(SOCKET_FACTORY_FALLBACK, String.valueOf(this.socketFactoryFallback));
            p.put(SOCKEY_FACTORY_PORT, String.valueOf(this.socketFactoryPort));
        }
        return p;
    }

    protected NativeDmProperty(NativeDmPropertyBuilder<?, ?> b) {
        super(b);
        this.host = ((NativeDmPropertyBuilder)b).host;
        this.port = ((NativeDmPropertyBuilder)b).port;
        this.auth = ((NativeDmPropertyBuilder)b).auth;
        this.user = ((NativeDmPropertyBuilder)b).user;
        this.pass = ((NativeDmPropertyBuilder)b).pass;
        this.debug = ((NativeDmPropertyBuilder)b).debug;
        this.charset = ((NativeDmPropertyBuilder)b).charset;
        this.splitlongparameters = ((NativeDmPropertyBuilder)b).splitlongparameters;
        this.startttlsEnable = ((NativeDmPropertyBuilder)b).startttlsEnable;
        this.sslEnable = ((NativeDmPropertyBuilder)b).sslEnable;
        this.socketFactoryClass = ((NativeDmPropertyBuilder)b).socketFactoryClass;
        this.socketFactoryFallback = ((NativeDmPropertyBuilder)b).socketFactoryFallback;
        this.socketFactoryPort = ((NativeDmPropertyBuilder)b).socketFactoryPort;
        this.timeout = ((NativeDmPropertyBuilder)b).timeout;
        this.connectionTimeout = ((NativeDmPropertyBuilder)b).connectionTimeout;
        this.ccs = ((NativeDmPropertyBuilder)b).ccs;
        this.bccs = ((NativeDmPropertyBuilder)b).bccs;
        this.title = ((NativeDmPropertyBuilder)b).title;
        this.content = ((NativeDmPropertyBuilder)b).content;
        this.attachments = ((NativeDmPropertyBuilder)b).attachments;
        this.useGlobalSession = ((NativeDmPropertyBuilder)b).useGlobalSession;
    }

    public static NativeDmPropertyBuilder<?, ?> builder() {
        return new NativeDmPropertyBuilderImpl();
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getAuth() {
        return this.auth;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public java.nio.charset.Charset getCharset() {
        return this.charset;
    }

    public boolean isSplitlongparameters() {
        return this.splitlongparameters;
    }

    public boolean isStartttlsEnable() {
        return this.startttlsEnable;
    }

    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    public String getSocketFactoryClass() {
        return this.socketFactoryClass;
    }

    public boolean isSocketFactoryFallback() {
        return this.socketFactoryFallback;
    }

    public int getSocketFactoryPort() {
        return this.socketFactoryPort;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getCcs() {
        return this.ccs;
    }

    public String getBccs() {
        return this.bccs;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public File[] getAttachments() {
        return this.attachments;
    }

    public boolean isUseGlobalSession() {
        return this.useGlobalSession;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setCharset(java.nio.charset.Charset charset) {
        this.charset = charset;
    }

    public void setSplitlongparameters(boolean splitlongparameters) {
        this.splitlongparameters = splitlongparameters;
    }

    public void setStartttlsEnable(boolean startttlsEnable) {
        this.startttlsEnable = startttlsEnable;
    }

    public void setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public void setSocketFactoryClass(String socketFactoryClass) {
        this.socketFactoryClass = socketFactoryClass;
    }

    public void setSocketFactoryFallback(boolean socketFactoryFallback) {
        this.socketFactoryFallback = socketFactoryFallback;
    }

    public void setSocketFactoryPort(int socketFactoryPort) {
        this.socketFactoryPort = socketFactoryPort;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setCcs(String ccs) {
        this.ccs = ccs;
    }

    public void setBccs(String bccs) {
        this.bccs = bccs;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAttachments(File[] attachments) {
        this.attachments = attachments;
    }

    public void setUseGlobalSession(boolean useGlobalSession) {
        this.useGlobalSession = useGlobalSession;
    }

    private static final class NativeDmPropertyBuilderImpl
    extends NativeDmPropertyBuilder<NativeDmProperty, NativeDmPropertyBuilderImpl> {
        private NativeDmPropertyBuilderImpl() {
        }

        @Override
        protected NativeDmPropertyBuilderImpl self() {
            return this;
        }

        @Override
        public NativeDmProperty build() {
            return new NativeDmProperty(this);
        }
    }

    public static abstract class NativeDmPropertyBuilder<C extends NativeDmProperty, B extends NativeDmPropertyBuilder<C, B>>
    extends Property.PropertyBuilder<C, B> {
        private String host;
        private Integer port;
        private Boolean auth;
        private String user;
        private String pass;
        private boolean debug;
        private java.nio.charset.Charset charset;
        private boolean splitlongparameters;
        private boolean startttlsEnable;
        private Boolean sslEnable;
        private String socketFactoryClass;
        private boolean socketFactoryFallback;
        private int socketFactoryPort;
        private long timeout;
        private long connectionTimeout;
        private String ccs;
        private String bccs;
        private String title;
        private String content;
        private File[] attachments;
        private boolean useGlobalSession;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        public B auth(Boolean auth) {
            this.auth = auth;
            return (B)this.self();
        }

        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        public B pass(String pass) {
            this.pass = pass;
            return (B)this.self();
        }

        public B debug(boolean debug) {
            this.debug = debug;
            return (B)this.self();
        }

        public B charset(java.nio.charset.Charset charset) {
            this.charset = charset;
            return (B)this.self();
        }

        public B splitlongparameters(boolean splitlongparameters) {
            this.splitlongparameters = splitlongparameters;
            return (B)this.self();
        }

        public B startttlsEnable(boolean startttlsEnable) {
            this.startttlsEnable = startttlsEnable;
            return (B)this.self();
        }

        public B sslEnable(Boolean sslEnable) {
            this.sslEnable = sslEnable;
            return (B)this.self();
        }

        public B socketFactoryClass(String socketFactoryClass) {
            this.socketFactoryClass = socketFactoryClass;
            return (B)this.self();
        }

        public B socketFactoryFallback(boolean socketFactoryFallback) {
            this.socketFactoryFallback = socketFactoryFallback;
            return (B)this.self();
        }

        public B socketFactoryPort(int socketFactoryPort) {
            this.socketFactoryPort = socketFactoryPort;
            return (B)this.self();
        }

        public B timeout(long timeout) {
            this.timeout = timeout;
            return (B)this.self();
        }

        public B connectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return (B)this.self();
        }

        public B ccs(String ccs) {
            this.ccs = ccs;
            return (B)this.self();
        }

        public B bccs(String bccs) {
            this.bccs = bccs;
            return (B)this.self();
        }

        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        public B content(String content) {
            this.content = content;
            return (B)this.self();
        }

        public B attachments(File[] attachments) {
            this.attachments = attachments;
            return (B)this.self();
        }

        public B useGlobalSession(boolean useGlobalSession) {
            this.useGlobalSession = useGlobalSession;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "NativeDmProperty.NativeDmPropertyBuilder(super=" + super.toString() + ", host=" + this.host + ", port=" + this.port + ", auth=" + this.auth + ", user=" + this.user + ", pass=" + this.pass + ", debug=" + this.debug + ", charset=" + this.charset + ", splitlongparameters=" + this.splitlongparameters + ", startttlsEnable=" + this.startttlsEnable + ", sslEnable=" + this.sslEnable + ", socketFactoryClass=" + this.socketFactoryClass + ", socketFactoryFallback=" + this.socketFactoryFallback + ", socketFactoryPort=" + this.socketFactoryPort + ", timeout=" + this.timeout + ", connectionTimeout=" + this.connectionTimeout + ", ccs=" + this.ccs + ", bccs=" + this.bccs + ", title=" + this.title + ", content=" + this.content + ", attachments=" + Arrays.deepToString(this.attachments) + ", useGlobalSession=" + this.useGlobalSession + ")";
        }
    }
}

