/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class GoogleProvider
extends AbstractProvider {
    public GoogleProvider(Context context) {
        super(context, Registry.GOOGLE);
    }

    public GoogleProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.GOOGLE, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(callback.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).scope(object.getString("scope")).tokenType(object.getString("token_type")).idToken(object.getString("id_token")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + accToken.getAccessToken());
        String response = Httpx.post(this.userInfoUrl(accToken), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("sub")).username(object.getString("email")).avatar(object.getString("picture")).nickname(object.getString("name")).location(object.getString("locale")).email(object.getString("email")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", false, GoogleProvider.getScopes(true, OauthScope.Google.values()))).queryParam("prompt", "select_account").build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error") || object.containsKey((Object)"error_description")) {
            throw new AuthorizedException(object.containsKey((Object)"error") + ":" + object.getString("error_description"));
        }
    }
}

