/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class RenrenProvider
extends AbstractProvider {
    public RenrenProvider(Context context) {
        super(context, Registry.RENREN);
    }

    public RenrenProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.RENREN, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken)).getJSONObject("response");
        return Property.builder().rawJson(object).uuid(object.getString("id")).avatar(this.getAvatarUrl(object)).nickname(object.getString("name")).company(this.getCompany(object)).gender(this.getGender(object)).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(accToken.getRefreshToken()))).build();
    }

    private AccToken getToken(String url) {
        JSONObject object = JSONObject.parseObject((String)Httpx.post(url));
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException("Failed to get token from Renren: " + object);
        }
        return AccToken.builder().tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).accessToken(UriKit.encode(object.getString("access_token"))).refreshToken(UriKit.encode(object.getString("refresh_token"))).openId(object.getJSONObject("user").getString("id")).build();
    }

    private String getAvatarUrl(JSONObject userObj) {
        JSONArray jsonArray = userObj.getJSONArray("avatar");
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return null;
        }
        return jsonArray.getJSONObject(0).getString("url");
    }

    private Normal.Gender getGender(JSONObject userObj) {
        JSONObject object = userObj.getJSONObject("basicInformation");
        if (Objects.isNull(object)) {
            return Normal.Gender.UNKNOWN;
        }
        return Normal.Gender.getGender(object.getString("sex"));
    }

    private String getCompany(JSONObject userObj) {
        JSONArray array = userObj.getJSONArray("work");
        if (Objects.isNull(array) || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0).getString("name");
    }

    @Override
    public String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("userId", token.getOpenId()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, RenrenProvider.getScopes(true, OauthScope.Renren.values()))).build();
    }
}

