/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.process;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.process.LinesPumpStreamHandler;
import org.aoju.bus.office.process.ProcessManager;
import org.aoju.bus.office.process.ProcessQuery;

public abstract class AbstractProcessManager
implements ProcessManager {
    protected AbstractProcessManager() {
    }

    private String buildOutput(List<String> lines) {
        Objects.requireNonNull(lines, "lines must not be null");
        return lines.stream().filter(StringKit::isNotBlank).collect(Collectors.joining("\n"));
    }

    protected List<String> execute(String[] cmdarray) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdarray);
        LinesPumpStreamHandler streamsHandler = new LinesPumpStreamHandler(process.getInputStream(), process.getErrorStream());
        streamsHandler.start();
        try {
            process.waitFor();
            streamsHandler.stop();
        }
        catch (InterruptedException ex) {
            Logger.warn("The current thread was interrupted while waiting for command execution output.", ex);
            Thread.currentThread().interrupt();
        }
        List<String> outLines = streamsHandler.getOutputPumper().getLines();
        String out = this.buildOutput(outLines);
        String err = this.buildOutput(streamsHandler.getErrorPumper().getLines());
        if (!StringKit.isBlank(out)) {
            Logger.trace("Command Output: {}", out);
        }
        if (!StringKit.isBlank(err)) {
            Logger.trace("Command Error: {}", err);
        }
        return outLines;
    }

    @Override
    public long find(ProcessQuery query) throws IOException {
        Pattern commandPattern = Pattern.compile(Pattern.quote(query.getCommand()) + ".*" + Pattern.quote(query.getArgument()));
        Pattern processLinePattern = this.getRunningProcessLinePattern();
        String[] currentProcessesCommand = this.getRunningProcessesCommand(query.getCommand());
        Logger.trace("Finding PID using\nCommand to get current running processes: {}\nRegex used to match current running process lines: {}\nRegex used to match running office process we are looking for: {}", currentProcessesCommand, processLinePattern.pattern(), commandPattern.pattern());
        List<String> lines = this.execute(currentProcessesCommand);
        for (String line : lines) {
            if (StringKit.isBlank(line)) continue;
            Logger.trace("Checking if process line matches the process line regex\nProcess line: {}", line);
            Matcher lineMatcher = processLinePattern.matcher(line);
            if (!lineMatcher.matches()) continue;
            String pid = lineMatcher.group("Pid");
            String commandLine = lineMatcher.group("CommanLine");
            Logger.trace("Line matches!\npid: {}; Command line: {}\nChecking if this command line matches the office command line regex", pid, commandLine);
            Matcher commandMatcher = commandPattern.matcher(commandLine);
            if (!commandMatcher.find()) continue;
            Logger.debug("Command line matches! Returning pid: {}", pid);
            return Long.parseLong(pid);
        }
        return -2L;
    }

    protected abstract String[] getRunningProcessesCommand(String var1);

    protected abstract Pattern getRunningProcessLinePattern();
}

