/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.plugin;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.PageException;
import org.aoju.bus.pager.Paging;
import org.apache.ibatis.reflection.MetaObject;

public abstract class PageFromObject {
    protected static Boolean HAS_REQUEST;
    protected static Class<?> REQUEST_CLASS;
    protected static Method GET_PARAMETER_MAP;
    protected static Map<String, String> PARAMS;

    public static <T> Page<T> getPageFromObject(Object params, boolean required) {
        Object pageSizeZero;
        Object reasonable;
        int pageSize;
        int pageNo;
        if (params == null) {
            throw new PageException("\u65e0\u6cd5\u83b7\u53d6\u5206\u9875\u67e5\u8be2\u53c2\u6570!");
        }
        if (params instanceof Paging) {
            Paging pageParams = (Paging)params;
            Page page = null;
            if (pageParams.getPageNo() != null && pageParams.getPageSize() != null) {
                page = new Page(pageParams.getPageNo(), pageParams.getPageSize());
            }
            if (PageFromObject.isNotEmpty(pageParams.getOrderBy())) {
                if (page != null) {
                    page.setOrderBy(pageParams.getOrderBy());
                } else {
                    page = new Page();
                    page.setOrderBy(pageParams.getOrderBy());
                    page.setOrderByOnly(true);
                }
            }
            return page;
        }
        MetaObject paramsObject = null;
        if (HAS_REQUEST.booleanValue() && REQUEST_CLASS.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = org.aoju.bus.pager.reflect.MetaObject.forObject(GET_PARAMETER_MAP.invoke(params, new Object[0]));
            }
            catch (Exception e) {
                Logger.warn(e.getMessage(), new Object[0]);
            }
        } else {
            paramsObject = org.aoju.bus.pager.reflect.MetaObject.forObject(params);
        }
        if (paramsObject == null) {
            throw new PageException("\u5206\u9875\u67e5\u8be2\u53c2\u6570\u5904\u7406\u5931\u8d25!");
        }
        Object orderBy = PageFromObject.getParamValue(paramsObject, "orderBy", false);
        boolean hasOrderBy = false;
        if (orderBy != null && orderBy.toString().length() > 0) {
            hasOrderBy = true;
        }
        try {
            Object _pageNo = PageFromObject.getParamValue(paramsObject, "pageNo", required);
            Object _pageSize = PageFromObject.getParamValue(paramsObject, "pageSize", required);
            if (_pageNo == null || _pageSize == null) {
                if (hasOrderBy) {
                    Page page = new Page();
                    page.setOrderBy(orderBy.toString());
                    page.setOrderByOnly(true);
                    return page;
                }
                return null;
            }
            pageNo = Integer.parseInt(String.valueOf(_pageNo));
            pageSize = Integer.parseInt(String.valueOf(_pageSize));
        }
        catch (NumberFormatException e) {
            throw new PageException("\u5206\u9875\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b!", e);
        }
        Page page = new Page(pageNo, pageSize);
        Object _count = PageFromObject.getParamValue(paramsObject, "count", false);
        if (_count != null) {
            page.setCount(Boolean.valueOf(String.valueOf(_count)));
        }
        if (hasOrderBy) {
            page.setOrderBy(orderBy.toString());
        }
        if ((reasonable = PageFromObject.getParamValue(paramsObject, "reasonable", false)) != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = PageFromObject.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    protected static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            value = values.length == 0 ? null : values[0];
        }
        if (required && value == null) {
            throw new PageException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570:" + PARAMS.get(paramName));
        }
        return value;
    }

    public static void setParams(String params) {
        if (PageFromObject.isNotEmpty(params)) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().equals("");
    }

    public static boolean isNotEmpty(String str) {
        return !PageFromObject.isEmpty(str);
    }

    static {
        PARAMS = new HashMap<String, String>(6, 1.0f);
        try {
            REQUEST_CLASS = Class.forName("javax.servlet.ServletRequest");
            GET_PARAMETER_MAP = REQUEST_CLASS.getMethod("getParameterMap", new Class[0]);
            HAS_REQUEST = true;
        }
        catch (Throwable e) {
            HAS_REQUEST = false;
        }
        PARAMS.put("pageNo", "pageNo");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("orderBy", "orderBy");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
    }
}

