/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.core.io.WriteBuffer;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.handler.CompletionReadHandler;
import org.aoju.bus.socket.handler.CompletionWriteHandler;
import org.aoju.bus.socket.process.MessageProcessor;

public class TcpAioSession<T>
extends AioSession {
    private final AsynchronousSocketChannel channel;
    private final VirtualBuffer readBuffer;
    private final WriteBuffer byteBuf;
    private final Semaphore semaphore = new Semaphore(1);
    private final CompletionReadHandler<T> completionReadHandler;
    private final CompletionWriteHandler<T> completionWriteHandler;
    private final ServerConfig<T> serverConfig;
    private VirtualBuffer writeBuffer;
    private InputStream inputStream;

    TcpAioSession(AsynchronousSocketChannel channel, ServerConfig<T> config, CompletionReadHandler<T> completionReadHandler, CompletionWriteHandler<T> completionWriteHandler, PageBuffer pageBuffer) {
        this.channel = channel;
        this.completionReadHandler = completionReadHandler;
        this.completionWriteHandler = completionWriteHandler;
        this.serverConfig = config;
        this.readBuffer = pageBuffer.allocate(config.getReadBufferSize());
        Function<WriteBuffer, Void> flushFunction = var -> {
            if (!this.semaphore.tryAcquire()) {
                return null;
            }
            this.writeBuffer = var.poll();
            if (this.writeBuffer == null) {
                this.semaphore.release();
            } else {
                this.continueWrite(this.writeBuffer);
            }
            return null;
        };
        this.byteBuf = new WriteBuffer(pageBuffer, flushFunction, this.serverConfig.getWriteBufferSize(), this.serverConfig.getWriteBufferCapacity());
        config.getProcessor().stateEvent(this, SocketStatus.NEW_SESSION, null);
    }

    void initSession() {
        this.continueRead();
    }

    public void writeCompleted() {
        if (this.writeBuffer == null) {
            this.writeBuffer = this.byteBuf.poll();
        } else if (!this.writeBuffer.buffer().hasRemaining()) {
            this.writeBuffer.clean();
            this.writeBuffer = this.byteBuf.poll();
        }
        if (this.writeBuffer != null) {
            this.continueWrite(this.writeBuffer);
            return;
        }
        this.semaphore.release();
        if (this.status != 3) {
            this.close();
        } else {
            this.byteBuf.flush();
        }
    }

    @Override
    public final WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    @Override
    public synchronized void close(boolean immediate) {
        if (this.status == 1) {
            System.out.println("ignore, session:" + this.getSessionID() + " is closed:");
            return;
        }
        this.status = (byte)(immediate ? 1 : 2);
        if (immediate) {
            this.byteBuf.close();
            this.readBuffer.clean();
            if (this.writeBuffer != null) {
                this.writeBuffer.clean();
                this.writeBuffer = null;
            }
            IoKit.close(this.channel);
            this.serverConfig.getProcessor().stateEvent(this, SocketStatus.SESSION_CLOSED, null);
        } else if (!(this.writeBuffer != null && this.writeBuffer.buffer().hasRemaining() || this.byteBuf.hasData())) {
            this.close(true);
        } else {
            this.serverConfig.getProcessor().stateEvent(this, SocketStatus.SESSION_CLOSING, null);
            this.byteBuf.flush();
        }
    }

    @Override
    public final String getSessionID() {
        return "aioSession-" + this.hashCode();
    }

    @Override
    public final boolean isInvalid() {
        return this.status != 3;
    }

    public void readCompleted(boolean eof) {
        if (this.status == 1) {
            return;
        }
        ByteBuffer readBuffer = this.readBuffer.buffer();
        readBuffer.flip();
        MessageProcessor<T> messageProcessor = this.serverConfig.getProcessor();
        while (readBuffer.hasRemaining() && this.status == 3) {
            T dataEntry;
            try {
                dataEntry = this.serverConfig.getProtocol().decode(readBuffer, this);
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, SocketStatus.DECODE_EXCEPTION, e);
                throw e;
            }
            if (dataEntry == null) break;
            try {
                messageProcessor.process(this, dataEntry);
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, SocketStatus.PROCESS_EXCEPTION, e);
            }
        }
        if (eof || this.status == 2) {
            this.close(false);
            messageProcessor.stateEvent(this, SocketStatus.INPUT_SHUTDOWN, null);
            return;
        }
        if (this.status == 1) {
            return;
        }
        this.byteBuf.flush();
        readBuffer.compact();
        if (!readBuffer.hasRemaining()) {
            RuntimeException exception = new RuntimeException("readBuffer overflow");
            messageProcessor.stateEvent(this, SocketStatus.DECODE_EXCEPTION, exception);
            throw exception;
        }
        this.continueRead();
    }

    private void continueRead() {
        NetMonitor monitor = this.getServerConfig().getMonitor();
        if (monitor != null) {
            monitor.beforeRead(this);
        }
        this.channel.read(this.readBuffer.buffer(), 0L, TimeUnit.MILLISECONDS, this, this.completionReadHandler);
    }

    private int synRead() throws IOException {
        ByteBuffer buffer = this.readBuffer.buffer();
        if (buffer.remaining() > 0) {
            return 0;
        }
        try {
            buffer.clear();
            int size = this.channel.read(buffer).get();
            buffer.flip();
            return size;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void continueWrite(VirtualBuffer writeBuffer) {
        NetMonitor monitor = this.getServerConfig().getMonitor();
        if (monitor != null) {
            monitor.beforeWrite(this);
        }
        this.channel.write(writeBuffer.buffer(), 0L, TimeUnit.MILLISECONDS, this, this.completionWriteHandler);
    }

    @Override
    public final InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public final InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("session is closed");
        }
    }

    public ServerConfig<T> getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return this.inputStream == null ? this.getInputStream(-1) : this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputStream getInputStream(int length) throws IOException {
        if (this.inputStream != null) {
            throw new IOException("pre inputStream has not closed");
        }
        TcpAioSession tcpAioSession = this;
        synchronized (tcpAioSession) {
            if (this.inputStream == null) {
                this.inputStream = new InnerInputStream(length);
            }
        }
        return this.inputStream;
    }

    private class InnerInputStream
    extends InputStream {
        private int remainLength;

        InnerInputStream(int length) {
            this.remainLength = length >= 0 ? length : -1;
        }

        @Override
        public int read() throws IOException {
            if (this.remainLength == 0) {
                return -1;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            if (readBuffer.hasRemaining()) {
                --this.remainLength;
                return readBuffer.get();
            }
            if (TcpAioSession.this.synRead() == -1) {
                this.remainLength = 0;
            }
            return this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.remainLength == 0) {
                return -1;
            }
            if (this.remainLength > 0 && this.remainLength < len) {
                len = this.remainLength;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            int size = 0;
            while (len > 0 && TcpAioSession.this.synRead() != -1) {
                int readSize = Math.min(readBuffer.remaining(), len);
                readBuffer.get(b, off + size, readSize);
                size += readSize;
                len -= readSize;
            }
            this.remainLength -= size;
            return size;
        }

        @Override
        public int available() throws IOException {
            if (this.remainLength == 0) {
                return 0;
            }
            if (TcpAioSession.this.synRead() == -1) {
                this.remainLength = 0;
                return this.remainLength;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            if (this.remainLength < -1) {
                return readBuffer.remaining();
            }
            return Math.min(this.remainLength, readBuffer.remaining());
        }

        @Override
        public void close() {
            if (TcpAioSession.this.inputStream == this) {
                TcpAioSession.this.inputStream = null;
            }
        }
    }
}

