/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import com.alibaba.fastjson.JSON;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.AES;
import org.aoju.bus.crypto.symmetric.Symmetric;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.starter.goalie.GoalieConfiguration;
import org.aoju.bus.starter.goalie.GoalieProperties;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={GoalieConfiguration.class})
@Order(value=0x7FFFFFFE)
public class EncryptFilter
implements WebFilter {
    @Autowired
    GoalieProperties.Server.Encrypt encrypt;
    private Symmetric symmetric;

    @PostConstruct
    public void init() {
        if ("AES".equals(this.encrypt.getType())) {
            this.symmetric = new AES(Mode.CBC, Padding.PKCS7Padding, this.encrypt.getKey().getBytes(), this.encrypt.getOffset().getBytes());
        }
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.encrypt.isEnabled() && !Context.Format.binary.equals((Object)Context.get(exchange).getFormat())) {
            exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
        }
        return chain.filter(exchange);
    }

    private void doEncrypt(Message message) {
        if (ObjectKit.isNotNull(message.getData()) && "AES".equals(this.encrypt.getType())) {
            message.setData(this.symmetric.encryptBase64(JSON.toJSONString((Object)message.getData()), Charset.UTF_8));
        }
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                boolean isSign = Context.get(exchange).getAssets().isSign();
                if (isSign) {
                    Flux flux = Flux.from(body);
                    return super.writeWith((Publisher)DataBufferUtils.join((Publisher)flux).map(dataBuffer -> {
                        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(dataBuffer.asByteBuffer());
                        DataBufferUtils.release((DataBuffer)dataBuffer);
                        Message message = (Message)JSON.parseObject((String)charBuffer.toString(), Message.class);
                        EncryptFilter.this.doEncrypt(message);
                        return this.bufferFactory().wrap(JSON.toJSONString((Object)message).getBytes());
                    }));
                }
                return super.writeWith(body);
            }
        };
    }
}

