/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.image;

import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Centre;
import org.aoju.bus.image.Efforts;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.nimble.opencv.OpenCVNativeLoader;
import org.aoju.bus.image.plugin.StoreSCP;
import org.aoju.bus.starter.image.ImageProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ImageProperties.class})
public class ImageConfiguration {
    @Autowired
    ImageProperties properties;
    @Autowired
    Efforts efforts;

    @Bean(initMethod="start", destroyMethod="stop")
    public Centre onStoreSCP() {
        if (this.properties.opencv) {
            new OpenCVNativeLoader().init();
        }
        if (StringKit.isEmpty(this.properties.aeTitle)) {
            throw new NullPointerException("The aeTitle cannot be null.");
        }
        if (StringKit.isEmpty(this.properties.host)) {
            throw new NullPointerException("The host cannot be null.");
        }
        if (StringKit.isEmpty(this.properties.port)) {
            throw new NullPointerException("The port cannot be null.");
        }
        Args args = new Args(true);
        if (StringKit.isNotEmpty(this.properties.relClass)) {
            args.setExtendSopClassesURL(FileKit.getResource(this.properties.relClass, ImageConfiguration.class));
        }
        if (StringKit.isNotEmpty(this.properties.relClass)) {
            args.setExtendSopClassesURL(FileKit.getResource(this.properties.relClass, ImageConfiguration.class));
        }
        if (StringKit.isNotEmpty(this.properties.sopClass)) {
            args.setTransferCapabilityFile(FileKit.getResource(this.properties.sopClass, ImageConfiguration.class));
        }
        if (StringKit.isNotEmpty(this.properties.tcsClass)) {
            args.setExtendStorageSOPClass(FileKit.getResource(this.properties.tcsClass, ImageConfiguration.class));
        }
        return Centre.builder().args(args).efforts(this.efforts).node(new Node(this.properties.aeTitle, this.properties.host, Integer.valueOf(this.properties.port))).storeSCP(new StoreSCP(this.properties.dcmPath)).build();
    }
}

