/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.io.Serializable;
import java.util.Map;
import org.aoju.bus.core.toolkit.MapKit;

public class MapBuilder<K, V>
implements Serializable {
    private Map<K, V> map;

    public MapBuilder(Map<K, V> map) {
        this.map = map;
    }

    public static <K, V> MapBuilder<K, V> create() {
        return MapBuilder.create(false);
    }

    public static <K, V> MapBuilder<K, V> create(boolean isLinked) {
        return MapBuilder.create(MapKit.newHashMap(isLinked));
    }

    public static <K, V> MapBuilder<K, V> create(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public MapBuilder<K, V> put(K k, V v) {
        this.map.put(k, v);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    public Map<K, V> map() {
        return this.map;
    }

    public Map<K, V> build() {
        return this.map();
    }

    public String join(String separator, String keyValueSeparator) {
        return MapKit.join(this.map, separator, keyValueSeparator);
    }

    public String joinIgnoreNull(String separator, String keyValueSeparator) {
        return MapKit.joinIgnoreNull(this.map, separator, keyValueSeparator);
    }

    public String join(String separator, String keyValueSeparator, boolean isIgnoreNull) {
        return MapKit.join(this.map, separator, keyValueSeparator, isIgnoreNull);
    }
}

