/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.filter;

import java.util.HashSet;
import java.util.Set;
import org.aoju.bus.goalie.Assets;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.goalie.metric.Limiter;
import org.aoju.bus.goalie.registry.LimiterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483645)
public class LimitFilter
implements WebFilter {
    private final LimiterRegistry limiterRegistry;

    public LimitFilter(LimiterRegistry limiterRegistry) {
        this.limiterRegistry = limiterRegistry;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Context context = Context.get(exchange);
        Assets assets = context.getAssets();
        String ip = context.getRequestMap().get("x-remote-ip");
        Set<Limiter> cfgList = this.getLimiter(assets.getMethod() + assets.getVersion(), ip);
        for (Limiter cfg : cfgList) {
            cfg.acquire();
        }
        return chain.filter(exchange);
    }

    private Set<Limiter> getLimiter(String methodVersion, String ip) {
        String[] limitKeys = new String[]{methodVersion, ip + methodVersion};
        HashSet<Limiter> limitCfgList = new HashSet<Limiter>();
        for (String limitKey : limitKeys) {
            Limiter limitCfg = (Limiter)this.limiterRegistry.get(limitKey);
            if (null == limitCfg) continue;
            limitCfgList.add(limitCfg);
        }
        return limitCfgList;
    }
}

