/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;

@ThreadSafe
public final class NetStat {
    private NetStat() {
    }

    public static Pair<Long, Long> queryTcpnetstat() {
        long tcp4 = 0L;
        long tcp6 = 0L;
        List<String> activeConns = Executor.runNative("netstat -n -p tcp");
        for (String s : activeConns) {
            if (!s.endsWith("ESTABLISHED")) continue;
            if (s.startsWith("tcp4")) {
                ++tcp4;
                continue;
            }
            if (!s.startsWith("tcp6")) continue;
            ++tcp6;
        }
        return Pair.of(tcp4, tcp6);
    }

    public static List<InternetProtocolStats.IPConnection> queryNetstat() {
        ArrayList<InternetProtocolStats.IPConnection> connections = new ArrayList<InternetProtocolStats.IPConnection>();
        List<String> activeConns = Executor.runNative("netstat -n");
        for (String s : activeConns) {
            String[] split;
            if (!s.startsWith("tcp") && !s.startsWith("udp") || (split = RegEx.SPACES.split(s)).length < 5) continue;
            String state = split.length == 6 ? split[5] : null;
            String type = split[0];
            Pair<byte[], Integer> local = NetStat.parseIP(split[3]);
            Pair<byte[], Integer> foreign = NetStat.parseIP(split[4]);
            connections.add(new InternetProtocolStats.IPConnection(type, local.getLeft(), local.getRight(), foreign.getLeft(), foreign.getRight(), state == null ? InternetProtocolStats.TcpState.NONE : InternetProtocolStats.TcpState.valueOf(state), Builder.parseIntOrDefault(split[2], 0), Builder.parseIntOrDefault(split[1], 0), -1));
        }
        return connections;
    }

    private static Pair<byte[], Integer> parseIP(String s) {
        int portPos = s.lastIndexOf(46);
        if (portPos > 0 && s.length() > portPos) {
            int port = Builder.parseIntOrDefault(s.substring(portPos + 1), 0);
            String ip = s.substring(0, portPos);
            try {
                return Pair.of(InetAddress.getByName(ip).getAddress(), port);
            }
            catch (UnknownHostException e) {
                try {
                    ip = ip.endsWith(":") && ip.contains("::") ? ip + "0" : (ip.endsWith(":") || ip.contains("::") ? ip + ":0" : ip + "::0");
                    return Pair.of(InetAddress.getByName(ip).getAddress(), port);
                }
                catch (UnknownHostException e2) {
                    return Pair.of(new byte[0], port);
                }
            }
        }
        return Pair.of(new byte[0], 0);
    }
}

