/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractGraphicsCard;
import org.aoju.bus.health.builtin.hardware.GraphicsCard;

@Immutable
final class AixGraphicsCard
extends AbstractGraphicsCard {
    AixGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super(name, deviceId, vendor, versionInfo, vram);
    }

    public static List<GraphicsCard> getGraphicsCards(Supplier<List<String>> lscfg) {
        ArrayList<AixGraphicsCard> cardList = new ArrayList<AixGraphicsCard>();
        boolean display = false;
        String name = null;
        String vendor = null;
        ArrayList<String> versionInfo = new ArrayList<String>();
        for (String line : lscfg.get()) {
            String s = line.trim();
            if (s.startsWith("Name:") && s.contains("display")) {
                display = true;
                continue;
            }
            if (display && s.toLowerCase().contains("graphics")) {
                name = s;
                continue;
            }
            if (!display || name == null) continue;
            if (s.startsWith("Manufacture ID")) {
                vendor = Builder.removeLeadingDots(s.substring(14));
                continue;
            }
            if (s.contains("Level")) {
                versionInfo.add(s.replaceAll("\\.\\.+", "="));
                continue;
            }
            if (!s.startsWith("Hardware Location Code")) continue;
            cardList.add(new AixGraphicsCard(name, "unknown", StringKit.isBlank(vendor) ? "unknown" : vendor, versionInfo.isEmpty() ? "unknown" : String.join((CharSequence)",", versionInfo), 0L));
            display = false;
        }
        return Collections.unmodifiableList(cardList);
    }
}

