/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractHardwareAbstractionLayer;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.builtin.hardware.ComputerSystem;
import org.aoju.bus.health.builtin.hardware.Display;
import org.aoju.bus.health.builtin.hardware.GlobalMemory;
import org.aoju.bus.health.builtin.hardware.GraphicsCard;
import org.aoju.bus.health.builtin.hardware.HWDiskStore;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.health.builtin.hardware.PowerSource;
import org.aoju.bus.health.builtin.hardware.Sensors;
import org.aoju.bus.health.builtin.hardware.SoundCard;
import org.aoju.bus.health.builtin.hardware.UsbDevice;
import org.aoju.bus.health.unix.aix.Perfstat;
import org.aoju.bus.health.unix.aix.drivers.Lscfg;
import org.aoju.bus.health.unix.aix.drivers.perfstat.PerfstatDisk;
import org.aoju.bus.health.unix.aix.hardware.AixCentralProcessor;
import org.aoju.bus.health.unix.aix.hardware.AixComputerSystem;
import org.aoju.bus.health.unix.aix.hardware.AixDisplay;
import org.aoju.bus.health.unix.aix.hardware.AixGlobalMemory;
import org.aoju.bus.health.unix.aix.hardware.AixGraphicsCard;
import org.aoju.bus.health.unix.aix.hardware.AixHWDiskStore;
import org.aoju.bus.health.unix.aix.hardware.AixNetworkIF;
import org.aoju.bus.health.unix.aix.hardware.AixPowerSource;
import org.aoju.bus.health.unix.aix.hardware.AixSensors;
import org.aoju.bus.health.unix.aix.hardware.AixSoundCard;
import org.aoju.bus.health.unix.aix.hardware.AixUsbDevice;

@ThreadSafe
public final class AixHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    private final Supplier<List<String>> lscfg = Memoize.memoize(Lscfg::queryAllDevices, Memoize.defaultExpiration());
    private final Supplier<Perfstat.perfstat_disk_t[]> diskStats = Memoize.memoize(PerfstatDisk::queryDiskStats, Memoize.defaultExpiration());

    @Override
    public ComputerSystem createComputerSystem() {
        return new AixComputerSystem(this.lscfg);
    }

    @Override
    public GlobalMemory createMemory() {
        return new AixGlobalMemory(this.lscfg);
    }

    @Override
    public CentralProcessor createProcessor() {
        return new AixCentralProcessor();
    }

    @Override
    public Sensors createSensors() {
        return new AixSensors(this.lscfg);
    }

    @Override
    public List<PowerSource> getPowerSources() {
        return AixPowerSource.getPowerSources();
    }

    @Override
    public List<HWDiskStore> getDiskStores() {
        return AixHWDiskStore.getDisks(this.diskStats);
    }

    @Override
    public List<Display> getDisplays() {
        return AixDisplay.getDisplays();
    }

    @Override
    public List<NetworkIF> getNetworkIFs(boolean includeLocalInterfaces) {
        return AixNetworkIF.getNetworks(includeLocalInterfaces);
    }

    @Override
    public List<UsbDevice> getUsbDevices(boolean tree) {
        return AixUsbDevice.getUsbDevices(tree, this.lscfg);
    }

    @Override
    public List<SoundCard> getSoundCards() {
        return AixSoundCard.getSoundCards(this.lscfg);
    }

    @Override
    public List<GraphicsCard> getGraphicsCards() {
        return AixGraphicsCard.getGraphicsCards(this.lscfg);
    }
}

