/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class ProcstatKit {
    private ProcstatKit() {
    }

    public static Map<Integer, String> getCwdMap(int pid) {
        List<String> procstat = Executor.runNative("procstat -f " + (pid < 0 ? "-a" : Integer.valueOf(pid)));
        HashMap<Integer, String> cwdMap = new HashMap<Integer, String>();
        for (String line : procstat) {
            String[] split = RegEx.SPACES.split(line.trim(), 10);
            if (split.length != 10 || !split[2].equals("cwd")) continue;
            cwdMap.put(Builder.parseIntOrDefault(split[0], -1), split[9]);
        }
        return cwdMap;
    }

    public static String getCwd(int pid) {
        List<String> procstat = Executor.runNative("procstat -f " + pid);
        for (String line : procstat) {
            String[] split = RegEx.SPACES.split(line.trim(), 10);
            if (split.length != 10 || !split[2].equals("cwd")) continue;
            return split[9];
        }
        return "";
    }

    public static long getOpenFiles(int pid) {
        long fd = 0L;
        List<String> procstat = Executor.runNative("procstat -f " + pid);
        for (String line : procstat) {
            String[] split = RegEx.SPACES.split(line.trim(), 10);
            if (split.length != 10 || "Vd-".contains(split[4])) continue;
            ++fd;
        }
        return fd;
    }
}

