/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.drivers;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.GuardeBy;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.Win32Process;

@ThreadSafe
public final class Win32ProcessCached {
    private static final Supplier<Win32ProcessCached> INSTANCE = Memoize.memoize(Win32ProcessCached::createInstance);
    @GuardeBy(value="commandLineCacheLock")
    private final Map<Integer, Pair<Long, String>> commandLineCache = new HashMap<Integer, Pair<Long, String>>();
    private final ReentrantLock commandLineCacheLock = new ReentrantLock();

    private Win32ProcessCached() {
    }

    public static Win32ProcessCached getInstance() {
        return INSTANCE.get();
    }

    private static Win32ProcessCached createInstance() {
        return new Win32ProcessCached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommandLine(int processId, long startTime) {
        this.commandLineCacheLock.lock();
        try {
            Pair<Long, String> pair = this.commandLineCache.get(processId);
            if (pair != null && startTime < pair.getLeft()) {
                String string = pair.getRight();
                return string;
            }
            long now = System.currentTimeMillis();
            WbemcliUtil.WmiResult<Win32Process.CommandLineProperty> commandLineAllProcs = Win32Process.queryCommandLines(null);
            if (this.commandLineCache.size() > commandLineAllProcs.getResultCount() * 2) {
                this.commandLineCache.clear();
            }
            String result = "";
            for (int i = 0; i < commandLineAllProcs.getResultCount(); ++i) {
                int pid = WmiKit.getUint32(commandLineAllProcs, Win32Process.CommandLineProperty.PROCESSID, i);
                String cl = WmiKit.getString(commandLineAllProcs, Win32Process.CommandLineProperty.COMMANDLINE, i);
                this.commandLineCache.put(pid, Pair.of(now, cl));
                if (pid != processId) continue;
                result = cl;
            }
            String string = result;
            return string;
        }
        finally {
            this.commandLineCacheLock.unlock();
        }
    }
}

