/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractNetworkIF;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.health.windows.IPHlpAPI;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class WindowsNetworkIF
extends AbstractNetworkIF {
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final byte CONNECTOR_PRESENT_BIT = 32;
    private int ifType;
    private int ndisPhysicalMediumType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;

    public WindowsNetworkIF(NetworkInterface netint) {
        super(netint);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        ArrayList<WindowsNetworkIF> ifList = new ArrayList<WindowsNetworkIF>();
        for (NetworkInterface ni : WindowsNetworkIF.getNetworkInterfaces(includeLocalInterfaces)) {
            ifList.add(new WindowsNetworkIF(ni));
        }
        return Collections.unmodifiableList(ifList);
    }

    @Override
    public int getIfType() {
        return this.ifType;
    }

    @Override
    public int getNdisPhysicalMediumType() {
        return this.ndisPhysicalMediumType;
    }

    @Override
    public boolean isConnectorPresent() {
        return this.connectorPresent;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        if (IS_VISTA_OR_GREATER) {
            IPHlpAPI.MIB_IF_ROW2 ifRow = new IPHlpAPI.MIB_IF_ROW2();
            ifRow.InterfaceIndex = this.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
                Logger.error("Failed to retrieve data for interface {}, {}", this.queryNetworkInterface().getIndex(), this.getName());
                return false;
            }
            this.ifType = ifRow.Type;
            this.ndisPhysicalMediumType = ifRow.PhysicalMediumType;
            this.connectorPresent = (ifRow.InterfaceAndOperStatusFlags & 0x20) > 0;
            this.bytesSent = ifRow.OutOctets;
            this.bytesRecv = ifRow.InOctets;
            this.packetsSent = ifRow.OutUcastPkts;
            this.packetsRecv = ifRow.InUcastPkts;
            this.outErrors = ifRow.OutErrors;
            this.inErrors = ifRow.InErrors;
            this.collisions = ifRow.OutDiscards;
            this.inDrops = ifRow.InDiscards;
            this.speed = ifRow.ReceiveLinkSpeed;
        } else {
            IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
            ifRow.dwIndex = this.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
                Logger.error("Failed to retrieve data for interface {}, {}", this.queryNetworkInterface().getIndex(), this.getName());
                return false;
            }
            this.ifType = ifRow.dwType;
            this.bytesSent = Builder.unsignedIntToLong(ifRow.dwOutOctets);
            this.bytesRecv = Builder.unsignedIntToLong(ifRow.dwInOctets);
            this.packetsSent = Builder.unsignedIntToLong(ifRow.dwOutUcastPkts);
            this.packetsRecv = Builder.unsignedIntToLong(ifRow.dwInUcastPkts);
            this.outErrors = Builder.unsignedIntToLong(ifRow.dwOutErrors);
            this.inErrors = Builder.unsignedIntToLong(ifRow.dwInErrors);
            this.collisions = Builder.unsignedIntToLong(ifRow.dwOutDiscards);
            this.inDrops = Builder.unsignedIntToLong(ifRow.dwInDiscards);
            this.speed = Builder.unsignedIntToLong(ifRow.dwSpeed);
        }
        this.timeStamp = System.currentTimeMillis();
        return true;
    }
}

