/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.DnsX;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.ConnectionPool;
import org.aoju.bus.http.bodys.FormBody;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.magic.HttpProxy;
import org.aoju.bus.http.metric.Dispatcher;
import org.aoju.bus.http.secure.SSLSocketFactory;
import org.aoju.bus.http.secure.X509TrustManager;
import org.aoju.bus.logger.Logger;

public class Httpx {
    private static Httpd httpd;

    public Httpx() {
        this(30, 30, 30);
    }

    public Httpx(X509TrustManager x509TrustManager) {
        this(null, null, 30, 30, 30, 64, 5, 5, 5, SSLSocketFactory.createTrustAllSSLFactory(x509TrustManager), x509TrustManager, (hostname, session) -> true);
    }

    public Httpx(int connTimeout, int readTimeout, int writeTimeout) {
        this(null, null, connTimeout, readTimeout, writeTimeout, 64, 5, 5, 5);
    }

    public Httpx(int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration) {
        this(null, null, connTimeout, readTimeout, writeTimeout, maxRequests, maxRequestsPerHost, maxIdleConnections, keepAliveDuration);
    }

    public Httpx(DnsX dns, HttpProxy httpProxy, int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration) {
        this(dns, httpProxy, connTimeout, readTimeout, writeTimeout, maxRequests, maxRequestsPerHost, maxIdleConnections, keepAliveDuration, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Httpx(DnsX dns, HttpProxy httpProxy, int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration, javax.net.ssl.SSLSocketFactory sslSocketFactory, javax.net.ssl.X509TrustManager x509TrustManager, HostnameVerifier hostnameVerifier) {
        Class<Httpx> clazz = Httpx.class;
        synchronized (Httpx.class) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(maxRequests);
            dispatcher.setMaxRequestsPerHost(maxRequestsPerHost);
            ConnectionPool connectPool = new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.MINUTES);
            Httpd.Builder builder = new Httpd.Builder();
            builder.dispatcher(dispatcher);
            builder.connectionPool(connectPool);
            builder.addNetworkInterceptor(chain -> {
                Request request = chain.request();
                return chain.proceed(request);
            });
            if (ObjectKit.isNotEmpty((Object)dns)) {
                builder.dns(hostname -> {
                    try {
                        return dns.lookup(hostname);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return DnsX.SYSTEM.lookup(hostname);
                    }
                });
            }
            if (ObjectKit.isNotEmpty((Object)httpProxy)) {
                builder.proxy(httpProxy.proxy());
                if (httpProxy.user != null && httpProxy.password != null) {
                    builder.proxyAuthenticator(httpProxy.authenticator());
                }
            }
            builder.connectTimeout(connTimeout, TimeUnit.SECONDS);
            builder.readTimeout(readTimeout, TimeUnit.SECONDS);
            builder.writeTimeout(writeTimeout, TimeUnit.SECONDS);
            if (ObjectKit.isNotEmpty((Object)sslSocketFactory)) {
                builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
            }
            if (ObjectKit.isNotEmpty((Object)hostnameVerifier)) {
                builder.hostnameVerifier(hostnameVerifier);
            }
            httpd = builder.build();
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return;
        }
    }

    public static String get(String url) {
        return Httpx.get(url, "UTF-8");
    }

    public static String get(String url, String charset) {
        return Httpx.execute(Builder.builder().url(url).requestCharset(charset).responseCharset(charset).build());
    }

    public static String get(String url, boolean isAsync) {
        if (isAsync) {
            return Httpx.enqueue(Builder.builder().url(url).method("GET").build());
        }
        return Httpx.get(url);
    }

    public static String get(String url, Map<String, Object> queryMap) {
        return Httpx.get(url, queryMap, null, "UTF-8");
    }

    public static String get(String url, Map<String, Object> queryMap, Map<String, String> headerMap) {
        return Httpx.get(url, queryMap, headerMap, "UTF-8");
    }

    public static String get(String url, Map<String, Object> queryMap, Map<String, String> headerMap, String charset) {
        return Httpx.execute(Builder.builder().url(url).headerMap(headerMap).queryMap(queryMap).requestCharset(charset).responseCharset(charset).build());
    }

    public static void get(String url, Callback callback) {
        Request request = new Request.Builder().url(url).get().build();
        NewCall call = httpd.newCall(request);
        call.enqueue(callback);
    }

    public static void post(String url, Map<String, Object> queryMap, Callback callback) {
        StringBuilder data = new StringBuilder();
        if (ObjectKit.isNotEmpty(queryMap)) {
            Set<String> keys = queryMap.keySet();
            for (String key : keys) {
                data.append(key).append("=").append(queryMap.get(key)).append("&");
            }
        }
        RequestBody requestBody = RequestBody.create(MediaType.TEXT_HTML_TYPE, data.toString());
        Request request = new Request.Builder().url(url).post(requestBody).build();
        NewCall call = httpd.newCall(request);
        call.enqueue(callback);
    }

    public static String post(String url) {
        return Httpx.post(url, null);
    }

    public static String post(String url, Map<String, Object> formMap) {
        String data = "";
        if (MapKit.isNotEmpty(formMap)) {
            data = formMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        }
        return Httpx.post(url, data, "application/x-www-form-urlencoded");
    }

    public static String post(String url, String data, String mediaType) {
        return Httpx.post(url, data, mediaType, "UTF-8");
    }

    public static String post(String url, String data, String mediaType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("POST").data(data).mediaType(mediaType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, Object> queryMap, String mediaType) {
        return Httpx.post(url, queryMap, mediaType, "UTF-8");
    }

    public static String post(String url, Map<String, Object> queryMap, Map<String, String> headerMap) {
        return Httpx.post(url, queryMap, headerMap, "application/x-www-form-urlencoded");
    }

    public static String post(String url, Map<String, Object> queryMap, String mediaType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("POST").queryMap(queryMap).mediaType(mediaType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, Object> queryMap, Map<String, String> headerMap, String mediaType) {
        return Httpx.post(url, queryMap, headerMap, mediaType, "UTF-8");
    }

    public static String post(String url, Map<String, Object> queryMap, Map<String, String> headerMap, String mediaType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("POST").headerMap(headerMap).queryMap(queryMap).mediaType(mediaType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, Object> params, List<String> pathList) {
        MediaType mediaType = MediaType.valueOf("application/x-www-form-urlencoded;UTF-8");
        RequestBody bodyParams = RequestBody.create(mediaType, params.toString());
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE).addFormDataPart("params", "", bodyParams);
        for (String path : pathList) {
            File file = new File(path);
            requestBodyBuilder.addFormDataPart("file", file.getName(), RequestBody.create(mediaType, new File(path)));
        }
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post(requestBody).build();
        String result = "";
        try {
            Response response = httpd.newCall(request).execute();
            if (response.body() != null) {
                byte[] bytes = response.body().bytes();
                result = new String(bytes, "UTF-8");
            }
        }
        catch (Exception e) {
            Logger.error(">>>>>>>>Requesting HTTP Error [%s]<<<<<<<<", e);
        }
        return result;
    }

    private static Request.Builder builder(Builder builder) {
        if (StringKit.isBlank(builder.requestCharset)) {
            builder.requestCharset = "UTF-8";
        }
        if (StringKit.isBlank(builder.responseCharset)) {
            builder.responseCharset = "UTF-8";
        }
        if (StringKit.isBlank(builder.method)) {
            builder.method = "GET";
        }
        if (StringKit.isBlank(builder.mediaType)) {
            builder.mediaType = "application/x-www-form-urlencoded";
        }
        if (builder.tracer) {
            Logger.info(">>>>>>>>Builder[{}]<<<<<<<<", builder.toString());
        }
        Request.Builder request = new Request.Builder();
        if (MapKit.isNotEmpty(builder.headerMap)) {
            builder.headerMap.forEach(request::addHeader);
        }
        String method = builder.method.toUpperCase();
        String mediaType = String.format("%s;charset=%s", builder.mediaType, builder.requestCharset);
        if (StringKit.equals(method, "GET")) {
            if (MapKit.isNotEmpty(builder.queryMap)) {
                String queryParams = builder.queryMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
                builder.url = String.format("%s%s%s", builder.url, builder.url.contains("?") ? "&" : "?", queryParams);
            }
            request.get();
        } else if (ArrayKit.contains(new String[]{"POST", "PUT", "DELETE", "PATCH"}, method)) {
            if (StringKit.isNotEmpty(builder.data)) {
                RequestBody requestBody = RequestBody.create(MediaType.valueOf(mediaType), builder.data);
                request.method(method, requestBody);
            }
            if (MapKit.isNotEmpty(builder.queryMap)) {
                FormBody.Builder form = new FormBody.Builder(Charset.UTF_8);
                builder.queryMap.forEach((key, value) -> form.add((String)key, StringKit.toString(value)));
                request.method(method, form.build());
            }
        } else {
            throw new InstrumentException(String.format(">>>>>>>>Request Method Not found[%s]<<<<<<<<", method));
        }
        return request;
    }

    private static String execute(Builder builder) {
        Request.Builder request = Httpx.builder(builder);
        String result = "";
        try {
            Response response = httpd.newCall(request.url(builder.url).build()).execute();
            if (response.body() != null) {
                byte[] bytes = response.body().bytes();
                result = new String(bytes, builder.responseCharset);
            }
            if (builder.tracer) {
                Logger.info(">>>>>>>>Url[{}],Response[{}]<<<<<<<<", builder.url, result);
            }
        }
        catch (Exception e) {
            Logger.error(e, ">>>>>>>>Builder[{}] Error<<<<<<<<", builder.toString());
        }
        return result;
    }

    private static String enqueue(final Builder builder) {
        Request.Builder request = Httpx.builder(builder);
        NewCall call = httpd.newCall(request.url(builder.url).build());
        final String[] result = new String[]{""};
        call.enqueue(new Callback(){

            @Override
            public void onFailure(NewCall call, IOException e) {
                Logger.info(String.format(">>>>>>>>Url[%s] Failure<<<<<<<<", builder.url), new Object[0]);
            }

            @Override
            public void onResponse(NewCall call, Response response) throws IOException {
                if (response.body() != null) {
                    byte[] bytes = response.body().bytes();
                    result[0] = new String(bytes, builder.responseCharset);
                    if (builder.tracer) {
                        Logger.info(">>>>>>>>Url[{}],Response[{}]<<<<<<<<", builder.url, result[0]);
                    }
                }
            }
        });
        return result[0];
    }

    static {
        new Httpx(new X509TrustManager());
    }

    private static class Builder {
        private String url;
        private String method;
        private String data;
        private String mediaType;
        private Map<String, Object> queryMap;
        private Map<String, String> headerMap;
        private String requestCharset;
        private String responseCharset;
        private boolean tracer;

        Builder(String url, String method, String data, String mediaType, Map<String, Object> queryMap, Map<String, String> headerMap, String requestCharset, String responseCharset, boolean tracer) {
            this.url = url;
            this.method = method;
            this.data = data;
            this.mediaType = mediaType;
            this.queryMap = queryMap;
            this.headerMap = headerMap;
            this.requestCharset = requestCharset;
            this.responseCharset = responseCharset;
            this.tracer = tracer;
        }

        public static BuilderBuilder builder() {
            return new BuilderBuilder();
        }

        public String toString() {
            return "Httpx.Builder(url=" + this.url + ", method=" + this.method + ", data=" + this.data + ", mediaType=" + this.mediaType + ", queryMap=" + this.queryMap + ", headerMap=" + this.headerMap + ", requestCharset=" + this.requestCharset + ", responseCharset=" + this.responseCharset + ", tracer=" + this.tracer + ")";
        }

        public static class BuilderBuilder {
            private String url;
            private String method;
            private String data;
            private String mediaType;
            private Map<String, Object> queryMap;
            private Map<String, String> headerMap;
            private String requestCharset;
            private String responseCharset;
            private boolean tracer;

            BuilderBuilder() {
            }

            public BuilderBuilder url(String url) {
                this.url = url;
                return this;
            }

            public BuilderBuilder method(String method) {
                this.method = method;
                return this;
            }

            public BuilderBuilder data(String data) {
                this.data = data;
                return this;
            }

            public BuilderBuilder mediaType(String mediaType) {
                this.mediaType = mediaType;
                return this;
            }

            public BuilderBuilder queryMap(Map<String, Object> queryMap) {
                this.queryMap = queryMap;
                return this;
            }

            public BuilderBuilder headerMap(Map<String, String> headerMap) {
                this.headerMap = headerMap;
                return this;
            }

            public BuilderBuilder requestCharset(String requestCharset) {
                this.requestCharset = requestCharset;
                return this;
            }

            public BuilderBuilder responseCharset(String responseCharset) {
                this.responseCharset = responseCharset;
                return this;
            }

            public BuilderBuilder tracer(boolean tracer) {
                this.tracer = tracer;
                return this;
            }

            public Builder build() {
                return new Builder(this.url, this.method, this.data, this.mediaType, this.queryMap, this.headerMap, this.requestCharset, this.responseCharset, this.tracer);
            }

            public String toString() {
                return "Httpx.Builder.BuilderBuilder(url=" + this.url + ", method=" + this.method + ", data=" + this.data + ", mediaType=" + this.mediaType + ", queryMap=" + this.queryMap + ", headerMap=" + this.headerMap + ", requestCharset=" + this.requestCharset + ", responseCharset=" + this.responseCharset + ", tracer=" + this.tracer + ")";
            }
        }
    }
}

