/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.nimble.codec.Compressor;
import org.aoju.bus.image.nimble.codec.Decompressor;
import org.aoju.bus.image.nimble.codec.Transcoder;
import org.aoju.bus.image.nimble.codec.TransferSyntaxType;
import org.aoju.bus.logger.Logger;

public class Dcm2Dcm {
    private final List<Property> params = new ArrayList<Property>();
    private String tsuid;
    private TransferSyntaxType tstype;
    private boolean retainfmi;
    private boolean nofmi;
    private boolean legacy;
    private ImageEncodingOptions encOpts = ImageEncodingOptions.DEFAULT;
    private int maxThreads = 1;

    private static Object toValue(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : s);
        }
    }

    public final void setTransferSyntax(String uid) {
        this.tsuid = uid;
        this.tstype = TransferSyntaxType.forUID(uid);
        if (this.tstype == null) {
            throw new IllegalArgumentException("Unsupported Transfer Syntax: " + this.tsuid);
        }
    }

    public final void setRetainFileMetaInformation(boolean retainfmi) {
        this.retainfmi = retainfmi;
    }

    public final void setWithoutFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public final void setEncodingOptions(ImageEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    public void addCompressionParam(String name, Object value) {
        this.params.add(new Property(name, value));
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads <= 0) {
            throw new IllegalArgumentException("max-threads: " + maxThreads);
        }
        this.maxThreads = maxThreads;
    }

    private void mtranscode(List<String> srcList, File dest) {
        ExecutorService executorService = this.maxThreads > 1 ? Executors.newFixedThreadPool(this.maxThreads) : null;
        for (String src : srcList) {
            this.mtranscode(new File(src), dest, executorService);
        }
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    private void mtranscode(final File src, File dest, Executor executer) {
        File finalDest;
        if (src.isDirectory()) {
            dest.mkdir();
            for (File file : src.listFiles()) {
                this.mtranscode(file, new File(dest, file.getName()), executer);
            }
            return;
        }
        File file = finalDest = dest.isDirectory() ? new File(dest, src.getName()) : dest;
        if (executer != null) {
            executer.execute(new Runnable(){

                @Override
                public void run() {
                    Dcm2Dcm.this.transcode(src, finalDest);
                }
            });
        } else {
            this.transcode(src, finalDest);
        }
    }

    private void transcode(File src, File dest) {
        try {
            if (this.legacy) {
                this.transcodeLegacy(src, dest);
            } else {
                this.transcodeWithTranscoder(src, dest);
            }
            Logger.error(MessageFormat.format("transcoded {0} {1}", src, dest), new Object[0]);
        }
        catch (Exception e) {
            Logger.error(MessageFormat.format("failed {0} {1}", src, e.getMessage()), new Object[0]);
            throw new InstrumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcodeLegacy(File src, File dest) throws IOException {
        Attributes dataset;
        Attributes fmi;
        try (ImageInputStream dis = new ImageInputStream(src);){
            dis.setIncludeBulkData(ImageInputStream.IncludeBulkData.URI);
            fmi = dis.readFileMetaInformation();
            dataset = dis.readDataset(-1, -1);
        }
        Object pixeldata = dataset.getValue(2145386512);
        Compressor compressor = null;
        ImageOutputStream dos = null;
        try {
            String tsuid = this.tsuid;
            if (pixeldata != null) {
                if (this.tstype.isPixeldataEncapsulated()) {
                    tsuid = this.adjustTransferSyntax(tsuid, dataset.getInt(2621697, 8));
                    compressor = new Compressor(dataset, dis.getTransferSyntax());
                    compressor.compress(tsuid, this.params.toArray(new Property[this.params.size()]));
                } else if (pixeldata instanceof Fragments) {
                    Decompressor.decompress(dataset, dis.getTransferSyntax());
                }
            }
            if (this.nofmi) {
                fmi = null;
            } else if (this.retainfmi && fmi != null) {
                fmi.setString(131088, VR.UI, tsuid);
            } else {
                fmi = dataset.createFileMetaInformation(tsuid);
            }
            dos = new ImageOutputStream(dest);
            dos.setEncodingOptions(this.encOpts);
            dos.writeDataset(fmi, dataset);
        }
        catch (Throwable throwable) {
            IoKit.close(compressor);
            IoKit.close(dos);
            throw throwable;
        }
        IoKit.close(compressor);
        IoKit.close(dos);
    }

    public void transcodeWithTranscoder(File src, File dest) throws IOException {
        try (Transcoder transcoder = new Transcoder(src);){
            transcoder.setIncludeFileMetaInformation(!this.nofmi);
            transcoder.setRetainFileMetaInformation(this.retainfmi);
            transcoder.setEncodingOptions(this.encOpts);
            transcoder.setDestinationTransferSyntax(this.tsuid);
            if (this.tstype.isPixeldataEncapsulated()) {
                transcoder.setCompressParams(this.params.toArray(new Property[this.params.size()]));
            }
            transcoder.transcode((transcoder1, dataset) -> new FileOutputStream(dest));
        }
        catch (Exception e) {
            Files.delete(dest.toPath());
            throw e;
        }
    }

    private String adjustTransferSyntax(String tsuid, int bitsStored) {
        switch (this.tstype) {
            case JPEG_BASELINE: {
                if (bitsStored <= 8) break;
                return "1.2.840.10008.1.2.4.51";
            }
            case JPEG_EXTENDED: {
                if (bitsStored > 8) break;
                return "1.2.840.10008.1.2.4.50";
            }
        }
        return tsuid;
    }
}

