/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class CodingProvider
extends AbstractProvider {
    public CodingProvider(Context context) {
        super(context, Registry.CODING);
    }

    public CodingProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.CODING, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject accessTokenObject = JSONObject.parseObject((String)this.doGetAuthorizationCode(callback.getCode()));
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(object);
        object = object.getJSONObject("data");
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(object.getString("name")).avatar("https://coding.net/" + object.getString("avatar")).blog("https://coding.net/" + object.getString("path")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).gender(Normal.Gender.of(object.getString("sex"))).email(object.getString("email")).remark(object.getString("slogan")).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, CodingProvider.getScopes(true, OauthScope.Coding.values()))).queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.getIntValue("code") != 0) {
            throw new AuthorizedException(object.getString("msg"));
        }
    }
}

