/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class FeishuProvider
extends AbstractProvider {
    public FeishuProvider(Context context) {
        super(context, Registry.FEISHU);
    }

    public FeishuProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.FEISHU, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("app_access_token", (Object)this.getAppAccessToken());
        requestObject.put("grant_type", (Object)"authorization_code");
        requestObject.put("code", (Object)callback.getCode());
        return this.getToken(requestObject, this.source.accessToken());
    }

    @Override
    protected Property getUserInfo(AccToken accToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Authorization", "Bearer " + accToken.getAccessToken());
        String response = Httpx.post(this.source.userInfo(), null, header);
        JSONObject object = JSON.parseObject((String)response);
        this.checkResponse(object);
        JSONObject data = object.getJSONObject("data");
        return Property.builder().rawJson(object).uuid(data.getString("union_id")).username(data.getString("name")).nickname(data.getString("name")).avatar(data.getString("avatar_url")).email(data.getString("email")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken authToken) {
        JSONObject params = new JSONObject();
        params.put("app_access_token", (Object)this.getAppAccessToken());
        params.put("grant_type", (Object)"refresh_token");
        params.put("refresh_token", (Object)authToken.getRefreshToken());
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(params, this.source.refresh())).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("app_id", this.context.getAppKey()).queryParam("redirect_uri", UriKit.encode(this.context.getRedirectUri())).queryParam("state", this.getRealState(state)).build();
    }

    private String getAppAccessToken() {
        String cacheKey = this.source.getName().concat(":app_access_token:").concat(this.context.getAppKey());
        String cacheAppAccessToken = (String)this.extendCache.get(cacheKey);
        if (StringKit.isNotEmpty(cacheAppAccessToken)) {
            return cacheAppAccessToken;
        }
        String url = "https://open.feishu.cn/open-apis/auth/v3/app_access_token/internal/";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.context.getAppKey());
        params.put("app_secret", this.context.getAppSecret());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = Httpx.post(url, params, header);
        JSONObject jsonObject = JSON.parseObject((String)response);
        this.checkResponse(jsonObject);
        String appAccessToken = jsonObject.getString("app_access_token");
        this.extendCache.cache(cacheKey, appAccessToken, jsonObject.getLongValue("expire") * 1000L);
        return appAccessToken;
    }

    private AccToken getToken(JSONObject params, String url) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        String response = Httpx.post(url, (Map<String, Object>)params, header);
        JSONObject jsonObject = JSON.parseObject((String)response);
        this.checkResponse(jsonObject);
        JSONObject data = jsonObject.getJSONObject("data");
        return AccToken.builder().accessToken(data.getString("access_token")).refreshToken(data.getString("refresh_token")).expireIn(data.getIntValue("expires_in")).tokenType(data.getString("token_type")).openId(data.getString("open_id")).build();
    }

    private void checkResponse(JSONObject jsonObject) {
        if (jsonObject.getIntValue("code") != 0) {
            throw new AuthorizedException(jsonObject.getString("message"));
        }
    }
}

