/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.builtin;

import java.io.File;
import java.io.OutputStream;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.office.builtin.AbstractJob;
import org.aoju.bus.office.builtin.OptionalSource;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.magic.family.FormatRegistry;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.metric.TemporaryFileMaker;
import org.aoju.bus.office.provider.AbstractSourceProvider;
import org.aoju.bus.office.provider.AbstractTargetProvider;
import org.aoju.bus.office.provider.TargetFromFileProvider;
import org.aoju.bus.office.provider.TargetFromOutputStreamProvider;

public abstract class AbstractNorm
implements OptionalSource {
    private static final boolean DEFAULT_CLOSE_STREAM = true;
    protected final AbstractSourceProvider source;
    protected final OfficeManager officeManager;
    protected final FormatRegistry formatRegistry;

    protected AbstractNorm(AbstractSourceProvider source, OfficeManager officeManager, FormatRegistry formatRegistry) {
        this.source = source;
        this.officeManager = officeManager;
        this.formatRegistry = formatRegistry;
    }

    @Override
    public AbstractNorm as(DocumentFormat format) {
        this.source.setDocumentFormat(format);
        return this;
    }

    @Override
    public AbstractJob to(File target) {
        TargetFromFileProvider specs = new TargetFromFileProvider(target);
        DocumentFormat format = this.formatRegistry.getFormatByExtension(FileKit.getExtension(target.getName()));
        if (format != null) {
            specs.setDocumentFormat(format);
        }
        return this.toInternal(specs);
    }

    @Override
    public AbstractJob to(OutputStream target) {
        return this.to(target, true);
    }

    @Override
    public AbstractJob to(OutputStream target, boolean closeStream) {
        if (this.officeManager instanceof TemporaryFileMaker) {
            return this.toInternal(new TargetFromOutputStreamProvider(target, (TemporaryFileMaker)((Object)this.officeManager), closeStream));
        }
        throw new IllegalStateException("An office manager must implements the TemporaryFileMaker interface in order to be able to convert to OutputStream.");
    }

    protected abstract AbstractJob to(AbstractTargetProvider var1);

    private AbstractJob toInternal(AbstractTargetProvider target) {
        return this.to(target);
    }
}

