/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.dialect.general;

import java.util.Map;
import java.util.Properties;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.cache.Cache;
import org.aoju.bus.pager.cache.CacheFactory;
import org.aoju.bus.pager.dialect.AbstractSqlDialect;
import org.aoju.bus.pager.dialect.ReplaceSql;
import org.aoju.bus.pager.dialect.replace.RegexWithNolockReplaceSql;
import org.aoju.bus.pager.dialect.replace.SimpleWithNolockReplaceSql;
import org.aoju.bus.pager.parser.OrderByParser;
import org.aoju.bus.pager.parser.SqlServerParser;
import org.aoju.bus.pager.plugin.PageFromObject;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public class SqlServerDialect
extends AbstractSqlDialect {
    protected SqlServerParser pageSql = new SqlServerParser();
    protected Cache<String, String> CACHE_COUNTSQL;
    protected Cache<String, String> CACHE_PAGESQL;
    protected ReplaceSql replaceSql;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        String cacheSql = this.CACHE_COUNTSQL.get(sql);
        if (cacheSql != null) {
            return cacheSql;
        }
        cacheSql = sql;
        cacheSql = this.replaceSql.replace(cacheSql);
        cacheSql = this.countSqlParser.getSmartCountSql(cacheSql);
        cacheSql = this.replaceSql.restore(cacheSql);
        this.CACHE_COUNTSQL.put(sql, cacheSql);
        return cacheSql;
    }

    @Override
    public Object processPageParameter(MappedStatement ms, Map<String, Object> paramMap, Page page, BoundSql boundSql, CacheKey pageKey) {
        return paramMap;
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        Page page = this.getLocalPage();
        String orderBy = page.getOrderBy();
        if (Assert.isNotEmpty(orderBy)) {
            pageKey.update((Object)orderBy);
            sql = this.replaceSql.replace(sql);
            sql = OrderByParser.converToOrderBySql(sql, orderBy);
            sql = this.replaceSql.restore(sql);
        }
        return page.isOrderByOnly() ? sql : this.getPageSql(sql, page, pageKey);
    }

    @Override
    public String getPageSql(String sql, Page page, CacheKey pageKey) {
        pageKey.update((Object)page.getStartRow());
        pageKey.update((Object)page.getPageSize());
        String cacheSql = this.CACHE_PAGESQL.get(sql);
        if (cacheSql == null) {
            cacheSql = sql;
            cacheSql = this.replaceSql.replace(cacheSql);
            cacheSql = this.pageSql.convertToPageSql(cacheSql, null, null);
            cacheSql = this.replaceSql.restore(cacheSql);
            this.CACHE_PAGESQL.put(sql, cacheSql);
        }
        cacheSql = cacheSql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(page.getStartRow()));
        cacheSql = cacheSql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(page.getPageSize()));
        return cacheSql;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String replaceSql = properties.getProperty("replaceSql");
        if (PageFromObject.isEmpty(replaceSql) || "simple".equalsIgnoreCase(replaceSql)) {
            this.replaceSql = new SimpleWithNolockReplaceSql();
        } else if ("regex".equalsIgnoreCase(replaceSql)) {
            this.replaceSql = new RegexWithNolockReplaceSql();
        } else {
            try {
                this.replaceSql = (ReplaceSql)Class.forName(replaceSql).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("replaceSql \u53c2\u6570\u914d\u7f6e\u7684\u503c\u4e0d\u7b26\u5408\u8981\u6c42,\u53ef\u9009\u503c\u4e3a simple \u548c regex,\u6216\u8005\u662f\u5b9e\u73b0\u4e86 " + ReplaceSql.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5168\u9650\u5b9a\u7c7b\u540d", e);
            }
        }
        String sqlCacheClass = properties.getProperty("sqlCacheClass");
        if (PageFromObject.isNotEmpty(sqlCacheClass) && !sqlCacheClass.equalsIgnoreCase("false")) {
            this.CACHE_COUNTSQL = CacheFactory.createCache(sqlCacheClass, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(sqlCacheClass, "proxy", properties);
        } else {
            this.CACHE_COUNTSQL = CacheFactory.createCache(null, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(null, "proxy", properties);
        }
    }
}

