/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.office;

import java.util.stream.Stream;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.bridge.LocalOfficePoolManager;
import org.aoju.bus.office.bridge.OnlineOfficePoolManager;
import org.aoju.bus.office.magic.family.RegistryInstanceHolder;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.provider.LocalOfficeProvider;
import org.aoju.bus.office.provider.OnlineOfficeProvider;
import org.aoju.bus.starter.office.OfficeProperties;
import org.aoju.bus.starter.office.OfficeProviderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={LocalOfficeProvider.class, OnlineOfficeProvider.class})
@EnableConfigurationProperties(value={OfficeProperties.class})
public class OfficeConfiguration {
    @Autowired
    OfficeProperties properties;

    @Bean
    public OfficeProviderService previewProviderFactory(OfficeManager localOfficeManager, OfficeManager onlineOfficeManager) {
        return new OfficeProviderService(((LocalOfficeProvider.Builder)((LocalOfficeProvider.Builder)LocalOfficeProvider.builder().officeManager(localOfficeManager)).formatRegistry(RegistryInstanceHolder.getInstance())).build(), OnlineOfficeProvider.make(onlineOfficeManager));
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public OfficeManager localOfficeManager() {
        LocalOfficePoolManager.Builder builder = LocalOfficePoolManager.builder();
        if (!StringKit.isBlank(this.properties.getPortNumbers())) {
            builder.portNumbers(ArrayKit.toPrimitive((Integer[])Stream.of(StringKit.split((CharSequence)this.properties.getPortNumbers(), ",")).map(str -> MathKit.toInt(str, 8102)).toArray(Integer[]::new)));
        }
        builder.officeHome(this.properties.getOfficeHome());
        builder.workingDir(this.properties.getWorkingDir());
        builder.templateProfileDir(this.properties.getTemplateProfileDir());
        builder.killExistingProcess(this.properties.isKillExistingProcess());
        builder.processTimeout(this.properties.getProcessTimeout());
        builder.processRetryInterval(this.properties.getProcessRetryInterval());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.maxTasksPerProcess(this.properties.getMaxTasksPerProcess());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        String processManagerClass = this.properties.getProcessManagerClass();
        if (StringKit.isNotEmpty(processManagerClass)) {
            builder.processManager(processManagerClass);
        } else {
            builder.processManager(Builder.findBestProcessManager());
        }
        return builder.build();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public OfficeManager onlineOfficeManager() {
        OnlineOfficePoolManager.Builder builder = OnlineOfficePoolManager.builder();
        builder.urlConnection(this.properties.getUrl());
        builder.poolSize(this.properties.getPoolSize());
        builder.workingDir(this.properties.getWorkingDir());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        return builder.build();
    }
}

