package org.aoju.bus.core.date;

import org.aoju.bus.core.date.calendar.DayWrapper;
import org.aoju.bus.core.date.calendar.MonthWrapper;
import org.aoju.bus.core.date.calendar.NonWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Test {

    public static void main(String[] args) {
        // solar();
        // lunar();
        // holiday();
        // calendarTest();
    }

    public static void solar() {
        //阳历今天
        Solar date = new Solar();
        //输出阳历信息
        System.out.println(date.build(true));
        //输出阴历信息
        System.out.println(date.getLunar().build(true));
        System.out.println();
        //指定某个阳历日期
        date = new Solar();
        System.out.println(date.build(true));

        Lunar lunar = date.getLunar();
        System.out.println(lunar.build(true));
    }

    public static void lunar() {
        Lunar date = new Lunar(2021, 01, 05);
        System.out.println(date.build(true));
        System.out.println(date.getSolar().build(true));
        System.out.println("一九八六年四月廿一 丙寅(虎)年 癸巳(蛇)月 癸酉(鸡)日 子(鼠)时 纳音[炉中火 长流水 剑锋金 桑柘木] 星期四 北方玄武 星宿[斗木獬](吉) 彭祖百忌[癸不词讼理弱敌强 酉不会客醉坐颠狂] 喜神方位[巽](东南) 阳贵神方位[巽](东南) 阴贵神方位[震](正东) 福神方位[兑](正西) 财神方位[离](正南) 冲[(丁卯)兔] 煞[东]" +
                "1986-05-29 00:00:00 星期四 双子座");

    }

    public static void holiday() {
        System.out.println(Holiday.getHolidays("2020-04"));
      /*  System.out.println(Holiday.getHoliday("2020-01-01"));
        System.out.println(Holiday.getHoliday("2020-04-01"));
        System.out.println(Holiday.getHolidays("202002"));
        System.out.println(Holiday.getHolidays("20200201"));
        System.out.println(Holiday.getHoliday(1999, 1, 5));
        System.out.println(Holiday.getHoliday(2019, 1, 1));
        System.out.println(Holiday.getHolidays(2020, 5));
        System.out.println(Holiday.getHolidays(2020));

        System.out.println(Holiday.getHolidaysByTarget("20200501"));
        System.out.println(Holiday.getHolidaysByTarget(2011, 1, 1));*/
    }

    public static void calendarTest() {
        // 工作日自定义 2020-08-07周五本为工作日，这里特别设置为非工作日，2020-08-08周六本为非工作日，这里特别设置为工作日
        Map<String, Integer> dateTypeMap = new HashMap<>();
        dateTypeMap.put("2020-08-07", 0);
        dateTypeMap.put("2020-08-08", 1);

        // 获取2020年8月日历，包含农历和所有节假日信息，包含自定义数据
        NonWrapper nonWrapper = Kalendar.calendar(2020, dateTypeMap);

        System.out.println(nonWrapper.getDayList().size());
    }

    /**
     * 日历基本测试 generateCalendarWithHoliday
     */
    public void calendarMonthTest() {
        // 获取2020年日历，包含农历和所有节假日信息
        NonWrapper nonWrapper = Kalendar.calendar(2020, 3);
        // 输出年
        System.out.println(nonWrapper.getYears().get(0).getYear());
        // 输出1月
        System.out.println(nonWrapper.getYears().get(0).getMonths().get(0).getMonth());
        // 输出1日
        System.out.println(nonWrapper.getYears().get(0).getMonths().get(0).getDays().get(0).getDay());
        // 输出1日日期格式化
        System.out.println(nonWrapper.getYears().get(0).getMonths().get(0).getDays().get(0).getDateStr());
        // 输出1日星期
        System.out.println(nonWrapper.getYears().get(0).getMonths().get(0).getDays().get(0).getWeekCnLong());
        // 输出1日的数据值
        System.out.println(nonWrapper.getYears().get(0).getMonths().get(0).getDays().get(0).getObject());

        // 获取指定日期的天，并对当前天设置扩展信息
        DayWrapper dayW = nonWrapper.getDayMap().get("2020-03-15");
        if (dayW != null) {
            dayW.setObject("hello 2020-03-15!");
        }

        // 获取指定日期的天的扩展信息
        System.out.println(nonWrapper.getDayMap().get("2020-03-15").getObject());
        System.out.println(nonWrapper.getYears().get(0).getMonths().get(0).getDays().get(14).getObject());

        MonthWrapper month = nonWrapper.getYears().get(0).getMonths().get(0);
        int length = month.getLength();
        List<DayWrapper> days = month.getDays();
        int blankNum = days.get(0).getWeek();
        if (blankNum == 7) {
            blankNum = 0;
        }

        // 打印日历
        // 1.表头
        System.out.println("===================================================" + month.getMonthCnLong() + "=================================================");
        System.out.print("日\t\t一\t\t二\t\t三\t\t四\t\t五\t\t六");

        // 循环打印日历内容
        // 记录当前日期值
        int count = 0;
        for (int i = 0; i < 6; i++) {
            for (int j = 0; j < 7; j++) {
                // 打印空白
                if (i == 0 && j < blankNum) {
                    System.out.print("\t\t");
                    continue;
                }

                if (count >= length) {
                    break;
                }

                // 打印日期信息
                DayWrapper dayWrapper = days.get(count);
                System.out.print(dayWrapper.getDay() + "\t\t");//天
                count++;
            }
            System.out.println();
        }
    }

    /*
     * 日历自定义测试 generateCalendarWithHoliday
     */
    public void calendarMonthCustomTest() {
        // 工作日自定义 2020-08-07周五本为工作日，这里特别设置为非工作日，2020-08-08周六本为非工作日，这里特别设置为工作日
        Map<String, Integer> dateTypeMap = new HashMap<>();
        dateTypeMap.put("2020-08-07", 0);
        dateTypeMap.put("2020-08-08", 1);

        // 获取2020年8月日历，包含农历和所有节假日信息，包含自定义数据
        NonWrapper nonWrapper = Kalendar.calendar(2020, 8, dateTypeMap);
        MonthWrapper month = nonWrapper.getYears().get(0).getMonths().get(0);
        int length = month.getLength();
        List<DayWrapper> days = month.getDays();
        int blankNum = days.get(0).getWeek();
        if (blankNum == 7) {
            blankNum = 0;
        }

        // 打印日历
        // 1.表头
        System.out.println("===================================================" + month.getMonthCnLong() + "=================================================");
        System.out.print("日\t\t一\t\t二\t\t三\t\t四\t\t五\t\t六");

        // 循环打印日历内容
        // 记录当前日期值
        int count = 0;
        for (int i = 0; i < 6; i++) {
            for (int j = 0; j < 7; j++) {
                // 打印空白
                if (i == 0 && j < blankNum) {
                    System.out.print("\t\t");
                    continue;
                }

                if (count >= length) {
                    break;
                }

                // 打印日期信息
                DayWrapper dayWrapper = days.get(count);
                System.out.print(dayWrapper.getDay() + "(");//天
                System.out.print(dayWrapper.getLocalHoliday());//公历节假日，会打印上面定义的 建军节
                System.out.print(dayWrapper.getLunarDay());//农历天
                System.out.print(dayWrapper.getChineseHoliday());//农历节假日，会打印上面定义的 七夕情人节
                System.out.print(dayWrapper.getSolarTerm());//二十四节气
                //是否工作日，1是，0否，默认周一到周五为工作日，周六周日为非工作日，
                //2020-08-07周五本为工作日，这里特别设置为非工作日，2020-08-08周六本为非工作日，这里特别设置为工作日，会重新设置
                System.out.print(dayWrapper.getDateType());
                System.out.print(")\t\t");
                count++;
            }
            System.out.println();
        }
    }

}
