/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.io.Serializable;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDescription;
import org.aoju.bus.core.clone.Cloning;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class DynamicBean
extends Cloning<DynamicBean>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Object bean;

    public DynamicBean(Class<?> beanClass, Object ... params) {
        this(ReflectKit.newInstance(beanClass, params));
    }

    public DynamicBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynamicBean) {
            bean = ((DynamicBean)bean).getBean();
        }
        this.bean = bean;
        this.beanClass = ClassKit.getClass(bean);
    }

    public DynamicBean(Class<?> beanClass) {
        this(ReflectKit.newInstance(beanClass, new Object[0]));
    }

    public static DynamicBean create(Object bean) {
        return new DynamicBean(bean);
    }

    public static DynamicBean create(Class<?> beanClass) {
        return new DynamicBean(beanClass);
    }

    public static DynamicBean create(Class<?> beanClass, Object ... params) {
        return new DynamicBean(beanClass, params);
    }

    public Object invoke(String methodName, Object ... params) {
        return ReflectKit.invoke(this.bean, methodName, params);
    }

    public <T> T get(String fieldName) throws InstrumentException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        PropertyDescription prop = BeanKit.getBeanDesc(this.beanClass).getProp(fieldName);
        if (null == prop) {
            throw new InstrumentException("No public field or get method for {}", fieldName);
        }
        return (T)prop.getValue(this.bean);
    }

    public void set(String fieldName, Object value) throws InstrumentException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
        } else {
            PropertyDescription prop = BeanKit.getBeanDesc(this.beanClass).getProp(fieldName);
            if (null == prop) {
                throw new InstrumentException("No public field or set method for {}", fieldName);
            }
            prop.setValue(this.bean, value);
        }
    }

    public boolean contains(String fieldName) {
        return null != BeanKit.getBeanDesc(this.beanClass).getProp(fieldName);
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicBean other = (DynamicBean)obj;
        if (this.bean == null) {
            return other.bean == null;
        }
        return this.bean.equals(other.bean);
    }

    public String toString() {
        return this.bean.toString();
    }
}

