/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.toolkit.ArrayKit;

public class EqualsBuilder
implements Builder<Boolean> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<Set<Pair<Builder.HashKey, Builder.HashKey>>> REGISTRY = new ThreadLocal();
    private boolean isEquals = true;

    static Set<Pair<Builder.HashKey, Builder.HashKey>> getRegistry() {
        return REGISTRY.get();
    }

    static Pair<Builder.HashKey, Builder.HashKey> getRegisterPair(Object lhs, Object rhs) {
        Builder.HashKey left = new Builder.HashKey(lhs);
        Builder.HashKey right = new Builder.HashKey(rhs);
        return Pair.of(left, right);
    }

    static boolean isRegistered(Object lhs, Object rhs) {
        Set<Pair<Builder.HashKey, Builder.HashKey>> registry = EqualsBuilder.getRegistry();
        Pair<Builder.HashKey, Builder.HashKey> pair = EqualsBuilder.getRegisterPair(lhs, rhs);
        Pair<Builder.HashKey, Builder.HashKey> swappedPair = Pair.of(pair.getKey(), pair.getValue());
        return registry != null && (registry.contains(pair) || registry.contains(swappedPair));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Object lhs, Object rhs) {
        Class<EqualsBuilder> clazz = EqualsBuilder.class;
        synchronized (EqualsBuilder.class) {
            if (EqualsBuilder.getRegistry() == null) {
                REGISTRY.set(new HashSet());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Set<Pair<Builder.HashKey, Builder.HashKey>> registry = EqualsBuilder.getRegistry();
            Pair<Builder.HashKey, Builder.HashKey> pair = EqualsBuilder.getRegisterPair(lhs, rhs);
            registry.add(pair);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void unregister(Object lhs, Object rhs) {
        Set<Pair<Builder.HashKey, Builder.HashKey>> registry = EqualsBuilder.getRegistry();
        if (registry == null) return;
        Pair<Builder.HashKey, Builder.HashKey> pair = EqualsBuilder.getRegisterPair(lhs, rhs);
        registry.remove(pair);
        Class<EqualsBuilder> clazz = EqualsBuilder.class;
        synchronized (EqualsBuilder.class) {
            registry = EqualsBuilder.getRegistry();
            if (registry == null || !registry.isEmpty()) return;
            REGISTRY.remove();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, Collection<String> excludeFields) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, ArrayKit.toArray(excludeFields, String.class));
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, String ... excludeFields) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, false, null, excludeFields);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients) {
        return EqualsBuilder.reflectionEquals(lhs, rhs, testTransients, null, new String[0]);
    }

    public static boolean reflectionEquals(Object lhs, Object rhs, boolean testTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        Class<?> testClass;
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Class<?> lhsClass = lhs.getClass();
        Class<?> rhsClass = rhs.getClass();
        if (lhsClass.isInstance(rhs)) {
            testClass = lhsClass;
            if (!rhsClass.isInstance(lhs)) {
                testClass = rhsClass;
            }
        } else if (rhsClass.isInstance(lhs)) {
            testClass = rhsClass;
            if (!lhsClass.isInstance(rhs)) {
                testClass = lhsClass;
            }
        } else {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        try {
            if (testClass.isArray()) {
                equalsBuilder.append(lhs, rhs);
            } else {
                EqualsBuilder.reflectionAppend(lhs, rhs, testClass, equalsBuilder, testTransients, excludeFields);
                while (testClass.getSuperclass() != null && testClass != reflectUpToClass) {
                    testClass = testClass.getSuperclass();
                    EqualsBuilder.reflectionAppend(lhs, rhs, testClass, equalsBuilder, testTransients, excludeFields);
                }
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return equalsBuilder.isEquals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reflectionAppend(Object lhs, Object rhs, Class<?> clazz, EqualsBuilder builder, boolean useTransients, String[] excludeFields) {
        if (EqualsBuilder.isRegistered(lhs, rhs)) {
            return;
        }
        try {
            EqualsBuilder.register(lhs, rhs);
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length && builder.isEquals; ++i) {
                AccessibleObject f = fields[i];
                if (ArrayKit.contains(excludeFields, ((Field)f).getName()) || ((Field)f).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers())) continue;
                try {
                    builder.append(((Field)f).get(lhs), ((Field)f).get(rhs));
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
        }
        finally {
            EqualsBuilder.unregister(lhs, rhs);
        }
    }

    public EqualsBuilder appendSuper(boolean superEquals) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = superEquals;
        return this;
    }

    public EqualsBuilder append(Object lhs, Object rhs) {
        if (!this.isEquals) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setEquals(false);
            return this;
        }
        Class<?> lhsClass = lhs.getClass();
        if (!lhsClass.isArray()) {
            this.isEquals = lhs.equals(rhs);
        }
        this.setEquals(ArrayKit.equals(lhs, rhs));
        return this;
    }

    public EqualsBuilder append(long lhs, long rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(int lhs, int rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(short lhs, short rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(char lhs, char rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(byte lhs, byte rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public EqualsBuilder append(double lhs, double rhs) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Double.doubleToLongBits(lhs), Double.doubleToLongBits(rhs));
    }

    public EqualsBuilder append(float lhs, float rhs) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Float.floatToIntBits(lhs), Float.floatToIntBits(rhs));
    }

    public EqualsBuilder append(boolean lhs, boolean rhs) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = lhs == rhs;
        return this;
    }

    public boolean isEquals() {
        return this.isEquals;
    }

    protected void setEquals(boolean isEquals) {
        this.isEquals = isEquals;
    }

    @Override
    public Boolean build() {
        return this.isEquals();
    }

    public void reset() {
        this.isEquals = true;
    }
}

