/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compare;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class FieldCompare<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Field field;

    public FieldCompare(Class<T> beanClass, String fieldName) {
        this.field = ClassKit.getDeclaredField(beanClass, fieldName);
        if (this.field == null) {
            throw new IllegalArgumentException(StringKit.format("Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return 1;
        }
        if (null == o2) {
            return -1;
        }
        try {
            v1 = (Comparable)ReflectKit.getFieldValue(o1, this.field);
            v2 = (Comparable)ReflectKit.getFieldValue(o2, this.field);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectKit.compare(fieldValue1, fieldValue2);
        if (0 == result) {
            result = ObjectKit.compare(o1, o2, true);
        }
        return result;
    }
}

