/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.EnumKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ReflectKit;

public class EnumConverter
extends AbstractConverter<Object> {
    private static final Map<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new ConcurrentHashMap();
    private final Class enumClass;

    public EnumConverter(Class enumClass) {
        this.enumClass = enumClass;
    }

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        Map<Class<?>, Method> valueOfMethods;
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)EnumKit.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (null == enumResult && MapKit.isNotEmpty(valueOfMethods = EnumConverter.getValueOfMethods(enumClass))) {
            Class<?> valueClass = value.getClass();
            for (Map.Entry<Class<?>, Method> entry : valueOfMethods.entrySet()) {
                if (!ClassKit.isAssignable(entry.getKey(), valueClass)) continue;
                enumResult = (Enum)ReflectKit.invokeStatic(entry.getValue(), value);
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getValueOfMethods(Class<?> enumClass) {
        Map<Class<?>, Method> valueOfMethods = VALUE_OF_METHOD_CACHE.get(enumClass);
        if (null == valueOfMethods) {
            valueOfMethods = Arrays.stream(enumClass.getMethods()).filter(BeanKit::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> false == "valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (existing, replacement) -> existing));
            VALUE_OF_METHOD_CACHE.put(enumClass, valueOfMethods);
        }
        return valueOfMethods;
    }

    @Override
    protected Object convertInternal(Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, this.enumClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(this.enumClass, this.convertString(value));
        }
        return enumValue;
    }

    @Override
    public Class getTargetType() {
        return this.enumClass;
    }
}

