/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.core.toolkit.ThreadKit;

public class PageBuffer {
    private final PageBuffer sharedPageBuffer;
    private final PageBuffer[] pagePool;
    private final ReentrantLock lock = new ReentrantLock();
    private final ByteBuffer buffer;
    private final ConcurrentLinkedQueue<VirtualBuffer> cleanBuffers = new ConcurrentLinkedQueue();
    private final List<VirtualBuffer> availableBuffers;
    private boolean idle = true;

    PageBuffer(PageBuffer[] pagePool, PageBuffer sharedPageBuffer, int size, boolean direct) {
        this.pagePool = pagePool;
        this.sharedPageBuffer = sharedPageBuffer;
        this.availableBuffers = new LinkedList<VirtualBuffer>();
        this.buffer = this.allocate0(size, direct);
        this.availableBuffers.add(new VirtualBuffer(this, null, this.buffer.position(), this.buffer.limit()));
    }

    private ByteBuffer allocate0(int size, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    public VirtualBuffer allocate(int size) {
        VirtualBuffer virtualBuffer = this.pagePool != null && Thread.currentThread() instanceof ThreadKit.FastBufferThread ? this.pagePool[(int)(Thread.currentThread().getId() % (long)this.pagePool.length)].allocate0(size) : this.allocate0(size);
        if (virtualBuffer != null) {
            return virtualBuffer;
        }
        if (this.sharedPageBuffer != null) {
            virtualBuffer = this.sharedPageBuffer.allocate0(size);
        }
        if (virtualBuffer == null) {
            virtualBuffer = new VirtualBuffer(null, this.allocate0(size, false), 0, 0);
        }
        return virtualBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualBuffer allocate0(int size) {
        if (size > this.buffer.capacity()) {
            return null;
        }
        this.idle = false;
        VirtualBuffer cleanBuffer = this.cleanBuffers.poll();
        if (cleanBuffer != null && cleanBuffer.getParentLimit() - cleanBuffer.getParentPosition() >= size) {
            cleanBuffer.buffer().clear();
            cleanBuffer.buffer(cleanBuffer.buffer());
            return cleanBuffer;
        }
        this.lock.lock();
        try {
            if (cleanBuffer != null) {
                this.clean0(cleanBuffer);
                while ((cleanBuffer = this.cleanBuffers.poll()) != null) {
                    if (cleanBuffer.getParentLimit() - cleanBuffer.getParentPosition() >= size) {
                        cleanBuffer.buffer().clear();
                        cleanBuffer.buffer(cleanBuffer.buffer());
                        VirtualBuffer virtualBuffer = cleanBuffer;
                        return virtualBuffer;
                    }
                    this.clean0(cleanBuffer);
                }
            }
            int count = this.availableBuffers.size();
            VirtualBuffer bufferChunk = null;
            if (count == 1) {
                bufferChunk = this.fastAllocate(size);
            } else if (count > 1) {
                bufferChunk = this.slowAllocate(size);
            }
            VirtualBuffer virtualBuffer = bufferChunk;
            return virtualBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private VirtualBuffer fastAllocate(int size) {
        VirtualBuffer bufferChunk;
        VirtualBuffer freeChunk = this.availableBuffers.get(0);
        if (freeChunk == (bufferChunk = this.allocate(size, freeChunk))) {
            this.availableBuffers.clear();
        }
        return bufferChunk;
    }

    private VirtualBuffer slowAllocate(int size) {
        Iterator<VirtualBuffer> iterator = this.availableBuffers.iterator();
        while (iterator.hasNext()) {
            VirtualBuffer bufferChunk;
            VirtualBuffer freeChunk = iterator.next();
            if (freeChunk == (bufferChunk = this.allocate(size, freeChunk))) {
                iterator.remove();
            }
            if (bufferChunk == null) continue;
            return bufferChunk;
        }
        return null;
    }

    private VirtualBuffer allocate(int size, VirtualBuffer freeChunk) {
        VirtualBuffer bufferChunk;
        int remaining = freeChunk.getParentLimit() - freeChunk.getParentPosition();
        if (remaining < size) {
            return null;
        }
        if (remaining == size) {
            this.buffer.limit(freeChunk.getParentLimit());
            this.buffer.position(freeChunk.getParentPosition());
            freeChunk.buffer(this.buffer.slice());
            bufferChunk = freeChunk;
        } else {
            this.buffer.limit(freeChunk.getParentPosition() + size);
            this.buffer.position(freeChunk.getParentPosition());
            bufferChunk = new VirtualBuffer(this, this.buffer.slice(), this.buffer.position(), this.buffer.limit());
            freeChunk.setParentPosition(this.buffer.limit());
        }
        if (bufferChunk.buffer().remaining() != size) {
            throw new RuntimeException("allocate " + size + ", buffer:" + bufferChunk);
        }
        return bufferChunk;
    }

    void clean(VirtualBuffer cleanBuffer) {
        this.cleanBuffers.offer(cleanBuffer);
    }

    void tryClean() {
        if (!this.idle) {
            this.idle = true;
        } else if (!this.cleanBuffers.isEmpty() && this.lock.tryLock()) {
            try {
                VirtualBuffer cleanBuffer;
                while ((cleanBuffer = this.cleanBuffers.poll()) != null) {
                    this.clean0(cleanBuffer);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void clean0(VirtualBuffer cleanBuffer) {
        ListIterator<VirtualBuffer> iterator = this.availableBuffers.listIterator();
        while (iterator.hasNext()) {
            VirtualBuffer freeBuffer = iterator.next();
            if (freeBuffer.getParentPosition() == cleanBuffer.getParentLimit()) {
                freeBuffer.setParentPosition(cleanBuffer.getParentPosition());
                return;
            }
            if (freeBuffer.getParentLimit() == cleanBuffer.getParentPosition()) {
                freeBuffer.setParentLimit(cleanBuffer.getParentLimit());
                if (iterator.hasNext()) {
                    VirtualBuffer next = iterator.next();
                    if (next.getParentPosition() == freeBuffer.getParentLimit()) {
                        freeBuffer.setParentLimit(next.getParentLimit());
                        iterator.remove();
                    } else if (next.getParentPosition() < freeBuffer.getParentLimit()) {
                        throw new IllegalStateException("");
                    }
                }
                return;
            }
            if (freeBuffer.getParentPosition() <= cleanBuffer.getParentLimit()) continue;
            iterator.previous();
            iterator.add(cleanBuffer);
            return;
        }
        iterator.add(cleanBuffer);
    }

    void release() {
        if (this.buffer.isDirect()) {
            this.buffer.clear();
        }
    }

    public String toString() {
        return "PageBuffer{availableBuffers=" + this.availableBuffers + ", cleanBuffers=" + this.cleanBuffers + '}';
    }
}

