/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.VirtualBuffer;

public final class WriteBuffer
extends OutputStream {
    private final VirtualBuffer[] items;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition waiting = this.lock.newCondition();
    private final PageBuffer pageBuffer;
    private final Consumer<WriteBuffer> consumer;
    private final int chunkSize;
    private volatile boolean isWaiting = false;
    private int takeIndex;
    private int putIndex;
    private int count;
    private VirtualBuffer writeInBuf;
    private boolean closed = false;
    private byte[] cacheByte;

    public WriteBuffer(PageBuffer pageBuffer, Consumer<WriteBuffer> consumer, int chunkSize, int capacity) {
        this.pageBuffer = pageBuffer;
        this.consumer = consumer;
        this.items = new VirtualBuffer[capacity];
        this.chunkSize = chunkSize;
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    public void writeShort(short v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[1] = (byte)(v & 0xFF);
        this.write(this.cacheByte, 0, 2);
    }

    public void writeByte(byte b) {
        this.lock.lock();
        try {
            if (this.writeInBuf == null) {
                this.writeInBuf = this.pageBuffer.allocate(this.chunkSize);
            }
            this.writeInBuf.buffer().put(b);
            this.flushWriteBuffer(false);
        }
        finally {
            this.lock.unlock();
        }
        this.consumer.accept(this);
    }

    private void flushWriteBuffer(boolean forceFlush) {
        if (!forceFlush && this.writeInBuf.buffer().hasRemaining()) {
            return;
        }
        this.consumer.accept(this);
        if (this.writeInBuf != null) {
            this.writeInBuf.buffer().flip();
            VirtualBuffer buffer = this.writeInBuf;
            this.writeInBuf = null;
            this.put(buffer);
        }
    }

    public void writeInt(int v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 24 & 0xFF);
        this.cacheByte[1] = (byte)(v >>> 16 & 0xFF);
        this.cacheByte[2] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[3] = (byte)(v & 0xFF);
        this.write(this.cacheByte, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 56 & 0xFFL);
        this.cacheByte[1] = (byte)(v >>> 48 & 0xFFL);
        this.cacheByte[2] = (byte)(v >>> 40 & 0xFFL);
        this.cacheByte[3] = (byte)(v >>> 32 & 0xFFL);
        this.cacheByte[4] = (byte)(v >>> 24 & 0xFFL);
        this.cacheByte[5] = (byte)(v >>> 16 & 0xFFL);
        this.cacheByte[6] = (byte)(v >>> 8 & 0xFFL);
        this.cacheByte[7] = (byte)(v & 0xFFL);
        this.write(this.cacheByte, 0, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            int minSize;
            this.waitPreWriteFinish();
            do {
                if (this.writeInBuf == null) {
                    this.writeInBuf = this.pageBuffer.allocate(Math.max(this.chunkSize, len));
                }
                ByteBuffer writeBuffer = this.writeInBuf.buffer();
                if (this.closed) {
                    this.writeInBuf.clean();
                    throw new IOException("writeBuffer has closed");
                }
                minSize = Math.min(writeBuffer.remaining(), len);
                writeBuffer.put(b, off, minSize);
                off += minSize;
                this.flushWriteBuffer(false);
            } while ((len -= minSize) > 0);
            this.notifyWaiting();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(ByteBuffer buffer) throws IOException {
        this.write(VirtualBuffer.wrap(buffer));
    }

    public void write(VirtualBuffer virtualBuffer) throws IOException {
        this.lock.lock();
        try {
            this.waitPreWriteFinish();
            if (this.writeInBuf != null && !virtualBuffer.buffer().isDirect() && this.writeInBuf.buffer().remaining() > virtualBuffer.buffer().remaining()) {
                this.writeInBuf.buffer().put(virtualBuffer.buffer());
                virtualBuffer.clean();
            } else {
                if (this.writeInBuf != null) {
                    this.flushWriteBuffer(true);
                }
                virtualBuffer.buffer().compact();
                this.writeInBuf = virtualBuffer;
            }
            this.flushWriteBuffer(false);
            this.notifyWaiting();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyWaiting() {
        this.isWaiting = false;
        this.waiting.signal();
    }

    private void initCacheBytes() {
        if (this.cacheByte == null) {
            this.cacheByte = new byte[8];
        }
    }

    private void waitPreWriteFinish() throws IOException {
        while (this.isWaiting) {
            try {
                this.waiting.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public void writeAndFlush(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.writeAndFlush(b, 0, b.length);
    }

    public void writeAndFlush(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len);
        this.flush();
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new RuntimeException("OutputStream has closed");
        }
        if (this.count > 0 || this.writeInBuf != null) {
            this.consumer.accept(this);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.lock.lock();
        try {
            VirtualBuffer byteBuf;
            this.flush();
            this.closed = true;
            while ((byteBuf = this.poll()) != null) {
                byteBuf.clean();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.count == 0 && this.writeInBuf == null;
    }

    public void put(VirtualBuffer virtualBuffer) {
        try {
            while (this.count == this.items.length) {
                this.isWaiting = true;
                this.notFull.await();
                if (!this.closed) continue;
                virtualBuffer.clean();
                return;
            }
            this.items[this.putIndex] = virtualBuffer;
            if (++this.putIndex == this.items.length) {
                this.putIndex = 0;
            }
            ++this.count;
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
    }

    public VirtualBuffer poll() {
        if (this.isEmpty()) {
            return null;
        }
        this.lock.lock();
        try {
            if (this.count == 0) {
                if (this.writeInBuf != null) {
                    this.writeInBuf.buffer().flip();
                    VirtualBuffer buffer = this.writeInBuf;
                    this.writeInBuf = null;
                    VirtualBuffer virtualBuffer = buffer;
                    return virtualBuffer;
                }
                VirtualBuffer buffer = null;
                return buffer;
            }
            VirtualBuffer x = this.items[this.takeIndex];
            this.items[this.takeIndex] = null;
            if (++this.takeIndex == this.items.length) {
                this.takeIndex = 0;
            }
            if (this.count-- == this.items.length) {
                this.notFull.signal();
            }
            VirtualBuffer virtualBuffer = x;
            return virtualBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }
}

