/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.key;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectID
implements Comparable<ObjectID>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int _genmachine;
    private static final AtomicInteger _nextInc;
    private final int _time;
    private final int _machine;
    private final int _inc;
    private boolean _new;

    public ObjectID(Date time) {
        this(time, _genmachine, _nextInc.getAndIncrement());
    }

    public ObjectID(Date time, int inc) {
        this(time, _genmachine, inc);
    }

    public ObjectID(Date time, int machine, int inc) {
        this._time = (int)(time.getTime() / 1000L);
        this._machine = machine;
        this._inc = inc;
        this._new = false;
    }

    public ObjectID(String s) {
        this(s, false);
    }

    public ObjectID(String s, boolean babble) {
        if (!ObjectID.isValid(s)) {
            throw new IllegalArgumentException("invalid ObjectId [" + s + "]");
        }
        if (babble) {
            s = ObjectID.babbleToMongod(s);
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        ByteBuffer bb = ByteBuffer.wrap(b);
        this._time = bb.getInt();
        this._machine = bb.getInt();
        this._inc = bb.getInt();
        this._new = false;
    }

    public ObjectID(byte[] b) {
        if (b.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        ByteBuffer bb = ByteBuffer.wrap(b);
        this._time = bb.getInt();
        this._machine = bb.getInt();
        this._inc = bb.getInt();
        this._new = false;
    }

    public ObjectID(int time, int machine, int inc) {
        this._time = time;
        this._machine = machine;
        this._inc = inc;
        this._new = false;
    }

    public ObjectID() {
        this._time = (int)(System.currentTimeMillis() / 1000L);
        this._machine = _genmachine;
        this._inc = _nextInc.getAndIncrement();
        this._new = true;
    }

    public static String id() {
        return new ObjectID().toString();
    }

    public static ObjectID get() {
        return new ObjectID();
    }

    public static boolean isValid(String text) {
        if (text == null) {
            return false;
        }
        int len = text.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static ObjectID massageToObjectId(Object o) {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof ObjectID) {
            return (ObjectID)o;
        }
        if (o instanceof String && ObjectID.isValid(s = o.toString())) {
            return new ObjectID(s);
        }
        return null;
    }

    static String _pos(String s, int p) {
        return s.substring(p * 2, p * 2 + 2);
    }

    public static String babbleToMongod(String b) {
        int i;
        if (!ObjectID.isValid(b)) {
            throw new IllegalArgumentException("invalid object id: " + b);
        }
        StringBuilder buf = new StringBuilder(24);
        for (i = 7; i >= 0; --i) {
            buf.append(ObjectID._pos(b, i));
        }
        for (i = 11; i >= 8; --i) {
            buf.append(ObjectID._pos(b, i));
        }
        return buf.toString();
    }

    public static int getGenMachineId() {
        return _genmachine;
    }

    public static int getCurrentInc() {
        return _nextInc.get();
    }

    public static int _flip(int x) {
        int z = 0;
        z |= x << 24 & 0xFF000000;
        z |= x << 8 & 0xFF0000;
        z |= x >> 8 & 0xFF00;
        return z |= x >> 24 & 0xFF;
    }

    public int hashCode() {
        int x = this._time;
        x += this._machine * 111;
        return x += this._inc * 17;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        ObjectID other = ObjectID.massageToObjectId(o);
        if (other == null) {
            return false;
        }
        return this._time == other._time && this._machine == other._machine && this._inc == other._inc;
    }

    public String toStringBabble() {
        return ObjectID.babbleToMongod(this.toStringMongod());
    }

    public String toStringMongod() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this._time);
        bb.putInt(this._machine);
        bb.putInt(this._inc);
        return b;
    }

    public String toString() {
        return this.toStringMongod();
    }

    int _compareUnsigned(int i, int j) {
        long li = 0xFFFFFFFFL;
        li = (long)i & li;
        long lj = 0xFFFFFFFFL;
        long diff = li - (lj = (long)j & lj);
        if (diff < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (diff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }

    @Override
    public int compareTo(ObjectID id) {
        if (id == null) {
            return -1;
        }
        int x = this._compareUnsigned(this._time, id._time);
        if (x != 0) {
            return x;
        }
        x = this._compareUnsigned(this._machine, id._machine);
        if (x != 0) {
            return x;
        }
        return this._compareUnsigned(this._inc, id._inc);
    }

    public int getMachine() {
        return this._machine;
    }

    public long getTime() {
        return (long)this._time * 1000L;
    }

    public int getTimeSecond() {
        return this._time;
    }

    public int getInc() {
        return this._inc;
    }

    public int _time() {
        return this._time;
    }

    public int _machine() {
        return this._machine;
    }

    public int _inc() {
        return this._inc;
    }

    public boolean isNew() {
        return this._new;
    }

    public void notNew() {
        this._new = false;
    }

    static {
        _nextInc = new AtomicInteger(new Random().nextInt());
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Exception e) {
                machinePiece = new Random().nextInt() << 16;
            }
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable ni) {
                // empty catch block
            }
            ClassLoader loader = ObjectID.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            _genmachine = machinePiece | processPiece;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

