/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.key;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.aoju.bus.core.toolkit.RandomKit;

public class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = 1L;
    private static final int MIN_RADIX = 2;
    private static final String STR_BASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final char[] DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final int MAX_RADIX = DIGITS.length;
    private static final Map<Character, Integer> DIGIT_MAP = new HashMap<Character, Integer>();
    private static final SecureRandom numberGenerator = RandomKit.getSecureRandom();
    private final long mostSigBits;
    private final long leastSigBits;

    private UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    public static int random(int min, int max) {
        return numberGenerator.nextInt(max - min + 1) + min;
    }

    public static UUID fastUUID() {
        return UUID.randomUUID(false);
    }

    public static UUID randomUUID() {
        return UUID.randomUUID(true);
    }

    public static String randomUUID32() {
        return java.util.UUID.randomUUID().toString().replace("-", "");
    }

    public static String randomUUID19() {
        java.util.UUID uuid = java.util.UUID.randomUUID();
        return UUID.digits(uuid.getMostSignificantBits() >> 32, 8) + UUID.digits(uuid.getMostSignificantBits() >> 16, 4) + UUID.digits(uuid.getMostSignificantBits(), 4) + UUID.digits(uuid.getLeastSignificantBits() >> 48, 4) + UUID.digits(uuid.getLeastSignificantBits(), 12);
    }

    public static String randomUUID15() {
        return UUIDMaker.generate();
    }

    public static long randomUUID15Long() {
        return UUID.toNumber(UUID.randomUUID15(), 10);
    }

    public static String randomUUIDBase64() {
        java.util.UUID uuid = java.util.UUID.randomUUID();
        byte[] byUuid = new byte[16];
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        UUID.long2bytes(most, byUuid, 0);
        UUID.long2bytes(least, byUuid, 8);
        return Base64.getEncoder().encodeToString(byUuid);
    }

    public static UUID randomUUID(boolean isSecure) {
        Random ng = isSecure ? numberGenerator : RandomKit.getRandom();
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return new UUID(randomBytes);
    }

    public static UUID nameUUIDFromBytes(byte[] name) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("MD5 not supported");
        }
        byte[] md5Bytes = md.digest(name);
        md5Bytes[6] = (byte)(md5Bytes[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0x80);
        return new UUID(md5Bytes);
    }

    public static UUID fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    private static void long2bytes(long value, byte[] bytes, int offset) {
        for (int i = 7; i > -1; --i) {
            bytes[offset++] = (byte)(value >> 8 * i & 0xFFL);
        }
    }

    private static long toNumber(String str, int radix) {
        Integer n;
        Integer n2;
        if (str == null) {
            throw new NumberFormatException("The str cannot be null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX");
        }
        if (radix > MAX_RADIX) {
            throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX");
        }
        boolean negative = false;
        Integer i = 0;
        Integer len = str.length();
        long result = 0L;
        long limit = -9223372036854775807L;
        if (len <= 0) {
            throw UUID.forInputString(str);
        }
        char firstChar = str.charAt(0);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                throw UUID.forInputString(str);
            }
            if (len == 1) {
                throw UUID.forInputString(str);
            }
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        long multmin = limit / (long)radix;
        while (i < len) {
            n2 = i;
            n = i = Integer.valueOf(i + 1);
            Integer digit = DIGIT_MAP.get(Character.valueOf(str.charAt(n2)));
            if (digit == null || digit < 0 || result < multmin) {
                throw UUID.forInputString(str);
            }
            if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                throw UUID.forInputString(str);
            }
            result -= (long)digit.intValue();
        }
        return negative ? result : -result;
    }

    private static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: " + s);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return (int)(this.mostSigBits >> 12 & 0xFL);
    }

    public int variant() {
        return (int)(this.leastSigBits >>> (int)(64L - (this.leastSigBits >>> 62)) & this.leastSigBits >> 63);
    }

    public long timestamp() throws UnsupportedOperationException {
        this.checkTimeBase();
        return (this.mostSigBits & 0xFFFL) << 48 | (this.mostSigBits >> 16 & 0xFFFFL) << 32 | this.mostSigBits >>> 32;
    }

    public int clockSequence() throws UnsupportedOperationException {
        this.checkTimeBase();
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public long node() throws UnsupportedOperationException {
        this.checkTimeBase();
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isSimple) {
        StringBuilder builder = new StringBuilder(isSimple ? 32 : 36);
        builder.append(UUID.digits(this.mostSigBits >> 32, 8));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.mostSigBits >> 16, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.mostSigBits, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.leastSigBits >> 48, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(this.leastSigBits, 12));
        return builder.toString();
    }

    public int hashCode() {
        long hilo = this.mostSigBits ^ this.leastSigBits;
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != UUID.class) {
            return false;
        }
        UUID id = (UUID)obj;
        return this.mostSigBits == id.mostSigBits && this.leastSigBits == id.leastSigBits;
    }

    @Override
    public int compareTo(UUID val) {
        return this.mostSigBits < val.mostSigBits ? -1 : (this.mostSigBits > val.mostSigBits ? 1 : (this.leastSigBits < val.leastSigBits ? -1 : (this.leastSigBits > val.leastSigBits ? 1 : 0)));
    }

    private void checkTimeBase() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
    }

    static {
        for (int i = 0; i < DIGITS.length; ++i) {
            DIGIT_MAP.put(Character.valueOf(DIGITS[i]), i);
        }
    }

    private static class UUIDMaker {
        private static final String STR = "abcdefghijklmnopqrstuvwxyz0123456789";
        private static final int PIX_LEN = "abcdefghijklmnopqrstuvwxyz0123456789".length();
        private static volatile int pixOne = 0;
        private static volatile int pixTwo = 0;
        private static volatile int pixThree = 0;
        private static volatile int pixFour = 0;

        private UUIDMaker() {
        }

        private static synchronized String generate() {
            String hexString = Long.toHexString(System.currentTimeMillis());
            if (++pixFour == PIX_LEN) {
                pixFour = 0;
                if (++pixThree == PIX_LEN) {
                    pixThree = 0;
                    if (++pixTwo == PIX_LEN) {
                        pixTwo = 0;
                        if (++pixOne == PIX_LEN) {
                            pixOne = 0;
                        }
                    }
                }
            }
            return hexString + STR.charAt(pixOne) + STR.charAt(pixTwo) + STR.charAt(pixThree) + STR.charAt(pixFour);
        }
    }
}

