/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.tree;

import java.util.LinkedHashMap;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.tree.Node;
import org.aoju.bus.core.lang.tree.TreeEntity;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.TreeKit;

public class TreeMap<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final TreeEntity TreeEntity;
    private TreeMap<T> parent;

    public TreeMap() {
        this((TreeEntity)null);
    }

    public TreeMap(TreeEntity TreeEntity2) {
        this.TreeEntity = ObjectKit.defaultIfNull(TreeEntity2, org.aoju.bus.core.lang.tree.TreeEntity.DEFAULT);
    }

    public TreeMap<T> getParent() {
        return this.parent;
    }

    public TreeMap<T> setParent(TreeMap<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    public TreeMap<T> getNode(T id) {
        return TreeKit.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeKit.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeKit.getParentsName(this, includeCurrentNode);
    }

    @Override
    public T getId() {
        return (T)this.get(this.TreeEntity.getIdKey());
    }

    @Override
    public TreeMap<T> setId(T id) {
        this.put(this.TreeEntity.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.TreeEntity.getParentIdKey());
    }

    @Override
    public TreeMap<T> setParentId(T parentId) {
        this.put(this.TreeEntity.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.TreeEntity.getNameKey());
    }

    @Override
    public TreeMap<T> setName(CharSequence name) {
        this.put(this.TreeEntity.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.TreeEntity.getWeightKey());
    }

    @Override
    public TreeMap<T> setWeight(Comparable<?> weight) {
        this.put(this.TreeEntity.getWeightKey(), weight);
        return this;
    }

    public List<TreeMap<T>> getChildren() {
        return (List)this.get(this.TreeEntity.getChildrenKey());
    }

    public void setChildren(List<TreeMap<T>> children) {
        this.put(this.TreeEntity.getChildrenKey(), children);
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }
}

