/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Combine {
    private final String[] datas;

    public Combine(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n, int m) {
        if (0 == m) {
            return 1L;
        }
        if (n == m) {
            return MathKit.factorial(n) / MathKit.factorial(m);
        }
        return n > m ? MathKit.factorial(n, n - m) / MathKit.factorial(m) : 0L;
    }

    public static long countAll(int n) {
        if (n < 0 || n > 63) {
            throw new IllegalArgumentException(StringKit.format("countAll must have n >= 0 and n <= 63, but got n={}", n));
        }
        return n == 63 ? Long.MAX_VALUE : (1L << n) - 1L;
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Combine.count(this.datas.length, m));
        this.select(0, new String[m], 0, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Combine.countAll(this.datas.length));
        for (int i = 1; i <= this.datas.length; ++i) {
            result.addAll(this.select(i));
        }
        return result;
    }

    private void select(int dataIndex, String[] resultList, int resultIndex, List<String[]> result) {
        int resultCount = resultIndex + 1;
        int resultLen = resultList.length;
        if (resultCount > resultLen) {
            result.add(Arrays.copyOf(resultList, resultList.length));
            return;
        }
        for (int i = dataIndex; i < this.datas.length + resultCount - resultLen; ++i) {
            resultList[resultIndex] = this.datas[i];
            this.select(i + 1, resultList, resultIndex + 1, result);
        }
    }
}

