/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.util.Map;
import org.aoju.bus.core.lang.exception.InstrumentException;

public abstract class Lookups<V> {
    private static final Lookups<String> SYSTEM_PROPERTIES_LOOKUP = new SystemPropertiesLookups();

    protected Lookups() {
    }

    public static Lookups<String> systemPropertiesLookup() {
        return SYSTEM_PROPERTIES_LOOKUP;
    }

    public static <V> Lookups<V> mapLookup(Map<String, V> map) {
        return new MapLookups<V>(map);
    }

    public abstract String lookup(String var1);

    private static class SystemPropertiesLookups
    extends Lookups<String> {
        private SystemPropertiesLookups() {
        }

        @Override
        public String lookup(String key) {
            if (key.length() > 0) {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException e) {
                    throw new InstrumentException(e);
                }
            }
            return null;
        }
    }

    static class MapLookups<V>
    extends Lookups<V> {
        private final Map<String, V> map;

        MapLookups(Map<String, V> map) {
            this.map = map;
        }

        @Override
        public String lookup(String key) {
            if (this.map == null) {
                return null;
            }
            V obj = this.map.get(key);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }
}

