/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.io.AsyncTimeout;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.BufferSink;
import org.aoju.bus.core.io.BufferSource;
import org.aoju.bus.core.io.LifeCycle;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.RealSink;
import org.aoju.bus.core.io.RealSource;
import org.aoju.bus.core.io.Segment;
import org.aoju.bus.core.io.Sink;
import org.aoju.bus.core.io.Source;
import org.aoju.bus.core.io.StreamProgress;
import org.aoju.bus.core.io.Timeout;
import org.aoju.bus.core.io.streams.BOMInputStream;
import org.aoju.bus.core.io.streams.ByteArrayOutputStream;
import org.aoju.bus.core.io.streams.NullOutputStream;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.StringKit;

public class IoKit {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    private IoKit() {
    }

    public static void checkOffsetAndCount(long size, long offset, long byteCount) {
        if ((offset | byteCount) < 0L || offset > size || size - offset < byteCount) {
            throw new ArrayIndexOutOfBoundsException(String.format("size=%s offset=%s byteCount=%s", size, offset, byteCount));
        }
    }

    public static short reverseBytesShort(short s) {
        int i = s & 0xFFFF;
        int reversed = (i & 0xFF00) >>> 8 | (i & 0xFF) << 8;
        return (short)reversed;
    }

    public static int reverseBytesInt(int i) {
        return (i & 0xFF000000) >>> 24 | (i & 0xFF0000) >>> 8 | (i & 0xFF00) << 8 | (i & 0xFF) << 24;
    }

    public static long reverseBytesLong(long v) {
        return (v & 0xFF00000000000000L) >>> 56 | (v & 0xFF000000000000L) >>> 40 | (v & 0xFF0000000000L) >>> 24 | (v & 0xFF00000000L) >>> 8 | (v & 0xFF000000L) << 8 | (v & 0xFF0000L) << 24 | (v & 0xFF00L) << 40 | (v & 0xFFL) << 56;
    }

    public static void sneakyRethrow(Throwable t) {
        IoKit.sneakyThrow2(t);
    }

    private static <T extends Throwable> void sneakyThrow2(Throwable t) throws T {
        throw t;
    }

    public static boolean arrayRangeEquals(byte[] a, int aOffset, byte[] b, int bOffset, int byteCount) {
        for (int i = 0; i < byteCount; ++i) {
            if (a[i + aOffset] == b[i + bOffset]) continue;
            return false;
        }
        return true;
    }

    public static long copy(Reader reader, Writer writer) throws InstrumentException {
        return IoKit.copy(reader, writer, 8192);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws InstrumentException {
        return IoKit.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws InstrumentException {
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            int readSize;
            while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
                writer.write(buffer, 0, readSize);
                size += (long)readSize;
                writer.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(InputStream in, OutputStream out) throws InstrumentException {
        return IoKit.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws InstrumentException {
        return IoKit.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws InstrumentException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        byte[] buffer = new byte[bufferSize];
        if (null != streamProgress) {
            streamProgress.start();
        }
        long size = 0L;
        try {
            int readSize = -1;
            while ((readSize = in.read(buffer)) != -1) {
                out.write(buffer, 0, readSize);
                size += (long)readSize;
                out.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(FileChannel inChannel, FileChannel outChannel) throws InstrumentException {
        Assert.notNull(inChannel, "In channel is null!", new Object[0]);
        Assert.notNull(outChannel, "Out channel is null!", new Object[0]);
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws InstrumentException {
        return IoKit.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws InstrumentException {
        return IoKit.copy(in, out, bufferSize, null);
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws InstrumentException {
        return IoKit.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws InstrumentException {
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws InstrumentException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 8192 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            while (in.read(byteBuffer) != -1) {
                byteBuffer.flip();
                size += (long)out.write(byteBuffer);
                byteBuffer.clear();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IoKit.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(BOMInputStream in) {
        return IoKit.getReader((InputStream)in, in.getCharset());
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoKit.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, String charsetName) throws InstrumentException {
        ByteArrayOutputStream out = IoKit.read(in);
        return StringKit.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws InstrumentException {
        ByteArrayOutputStream out = IoKit.read(in);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static ByteArrayOutputStream read(InputStream in) throws InstrumentException {
        return IoKit.read(in, true);
    }

    public static ByteArrayOutputStream read(InputStream in, boolean isClose) throws InstrumentException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IoKit.copy(in, out);
        }
        finally {
            if (isClose) {
                IoKit.close(in);
            }
        }
        return out;
    }

    public static String read(Reader reader) throws InstrumentException {
        return IoKit.read(reader, true);
    }

    public static String read(Reader reader, boolean isClose) throws InstrumentException {
        StringBuilder builder = StringKit.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip().toString());
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (isClose) {
                IoKit.close(reader);
            }
        }
        return builder.toString();
    }

    public static String readUtf8(FileChannel fileChannel) throws InstrumentException {
        return IoKit.read(fileChannel, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String read(FileChannel fileChannel, String charsetName) throws InstrumentException {
        return IoKit.read(fileChannel, org.aoju.bus.core.lang.Charset.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws InstrumentException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return StringKit.toString((ByteBuffer)buffer, charset);
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws InstrumentException {
        ByteArrayOutputStream out = IoKit.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static ByteArrayOutputStream read(ReadableByteChannel channel) throws InstrumentException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoKit.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static byte[] readBytes(InputStream in) throws InstrumentException {
        return IoKit.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isCLose) throws InstrumentException {
        if (in instanceof FileInputStream) {
            byte[] result;
            try {
                int available = in.available();
                result = new byte[available];
                int readLength = in.read(result);
                if (readLength != available) {
                    throw new IOException(StringKit.format("File length is [{}] but read [{}]!", available, readLength));
                }
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
            return result;
        }
        return IoKit.read(in, isCLose).toByteArray();
    }

    public static byte[] readBytes(InputStream in, int length) throws InstrumentException {
        int readLength;
        if (null == in) {
            return null;
        }
        if (length <= 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] b = new byte[length];
        try {
            readLength = in.read(b);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        if (readLength > 0 && readLength < length) {
            byte[] b2 = new byte[readLength];
            System.arraycopy(b, 0, b2, 0, readLength);
            return b2;
        }
        return b;
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws InstrumentException {
        return HexKit.encodeHexStr(IoKit.readBytes(in, length), toLowerCase);
    }

    public static String readHex28Upper(InputStream in) throws InstrumentException {
        return IoKit.readHex(in, 28, false);
    }

    public static String readHex28Lower(InputStream in) throws InstrumentException {
        return IoKit.readHex(in, 28, true);
    }

    public static <T> T readObj(InputStream in) throws InstrumentException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Object obj = ois.readObject();
            return (T)obj;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static <T extends Collection<String>> T readUtf8Lines(InputStream in, T collection) throws InstrumentException {
        return IoKit.readLines(in, org.aoju.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, String charsetName, T collection) throws InstrumentException {
        return IoKit.readLines(in, org.aoju.bus.core.lang.Charset.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws InstrumentException {
        return IoKit.readLines((Reader)IoKit.getReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws InstrumentException {
        IoKit.readLines(reader, line -> collection.add(line));
        return collection;
    }

    public static void readUtf8Lines(InputStream in, LineHandler lineHandler) throws InstrumentException {
        IoKit.readLines(in, org.aoju.bus.core.lang.Charset.UTF_8, lineHandler);
    }

    public static void readLines(InputStream in, Charset charset, LineHandler lineHandler) throws InstrumentException {
        IoKit.readLines((Reader)IoKit.getReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, LineHandler lineHandler) throws InstrumentException {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        BufferedReader bReader = IoKit.getReader(reader);
        try {
            String line;
            while ((line = bReader.readLine()) != null) {
                lineHandler.handle(line);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IoKit.toStream(content, org.aoju.bus.core.lang.Charset.charset(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IoKit.toStream(StringKit.bytes((CharSequence)content, charset));
    }

    public static ByteArrayInputStream toStream(String content) {
        return IoKit.toStream(content, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static InputStream toMarkSupportStream(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws InstrumentException {
        try {
            out.write(content);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (isCloseOut) {
                IoKit.close(out);
            }
        }
    }

    public static void writeUtf8(OutputStream out, boolean isCloseOut, Object ... contents) throws InstrumentException {
        IoKit.write(out, org.aoju.bus.core.lang.Charset.UTF_8, isCloseOut, contents);
    }

    public static void write(OutputStream out, String charsetName, boolean isCloseOut, Object ... contents) throws InstrumentException {
        IoKit.write(out, org.aoju.bus.core.lang.Charset.charset(charsetName), isCloseOut, contents);
    }

    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws InstrumentException {
        OutputStreamWriter osw = null;
        try {
            osw = IoKit.getWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toString(content, ""));
            }
            osw.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            if (isCloseOut) {
                IoKit.close(osw);
            }
        }
    }

    public static void write(OutputStream out, boolean isCloseOut, Serializable obj) throws InstrumentException {
        IoKit.writeObjects(out, isCloseOut, obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws InstrumentException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
                osw.flush();
            }
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoKit.close(osw);
                throw throwable;
            }
        }
        IoKit.close(osw);
        return;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable autoCloseable) {
        if (null != autoCloseable) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (AssertionError e) {
                if (!IoKit.isAndroidGetsocknameError(e)) {
                    throw e;
                }
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AsynchronousSocketChannel channel) {
        if (channel == null) {
            throw new NullPointerException();
        }
        try {
            channel.shutdownInput();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            channel.shutdownOutput();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws InstrumentException {
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws InstrumentException {
        input1 = IoKit.getReader(input1);
        input2 = IoKit.getReader(input2);
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws InstrumentException {
        BufferedReader br1 = IoKit.getReader(input1);
        BufferedReader br2 = IoKit.getReader(input2);
        try {
            String line1 = br1.readLine();
            String line2 = br2.readLine();
            while (line1 != null && line2 != null && line1.equals(line2)) {
                line1 = br1.readLine();
                line2 = br2.readLine();
            }
            return line1 == null ? line2 == null : line1.equals(line2);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static long checksumCRC32(InputStream in) throws InstrumentException {
        return IoKit.checksum(in, new CRC32()).getValue();
    }

    public static Checksum checksum(InputStream in, Checksum checksum) throws InstrumentException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum);
            IoKit.copy(in, new NullOutputStream());
        }
        finally {
            IoKit.close(in);
        }
        return checksum;
    }

    public static BufferSource buffer(Source source) {
        return new RealSource(source);
    }

    public static BufferSink buffer(Sink sink) {
        return new RealSink(sink);
    }

    public static Sink sink(OutputStream out) {
        return IoKit.sink(out, new Timeout());
    }

    private static Sink sink(final OutputStream out, final Timeout timeout) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) throws IOException {
                IoKit.checkOffsetAndCount(source.size, 0L, byteCount);
                while (byteCount > 0L) {
                    timeout.throwIfReached();
                    Segment head = source.head;
                    int toCopy = (int)Math.min(byteCount, (long)(head.limit - head.pos));
                    out.write(head.data, head.pos, toCopy);
                    head.pos += toCopy;
                    byteCount -= (long)toCopy;
                    source.size -= (long)toCopy;
                    if (head.pos != head.limit) continue;
                    source.head = head.pop();
                    LifeCycle.recycle(head);
                }
            }

            @Override
            public void flush() throws IOException {
                out.flush();
            }

            @Override
            public void close() throws IOException {
                out.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "sink(" + out + ")";
            }
        };
    }

    public static Sink sink(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        if (socket.getOutputStream() == null) {
            throw new IOException("socket's output stream == null");
        }
        AsyncTimeout timeout = IoKit.timeout(socket);
        Sink sink = IoKit.sink(socket.getOutputStream(), timeout);
        return timeout.sink(sink);
    }

    public static Source source(InputStream in) {
        return IoKit.source(in, new Timeout());
    }

    private static Source source(final InputStream in, final Timeout timeout) {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Source(){

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                if (byteCount < 0L) {
                    throw new IllegalArgumentException("byteCount < 0: " + byteCount);
                }
                if (byteCount == 0L) {
                    return 0L;
                }
                try {
                    timeout.throwIfReached();
                    Segment tail = sink.writableSegment(1);
                    int maxToCopy = (int)Math.min(byteCount, (long)(8192 - tail.limit));
                    int bytesRead = in.read(tail.data, tail.limit, maxToCopy);
                    if (bytesRead == -1) {
                        return -1L;
                    }
                    tail.limit += bytesRead;
                    sink.size += (long)bytesRead;
                    return bytesRead;
                }
                catch (AssertionError e) {
                    if (IoKit.isAndroidGetsocknameError(e)) {
                        throw new IOException((Throwable)((Object)e));
                    }
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "source(" + in + ")";
            }
        };
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return IoKit.source(new FileInputStream(file));
    }

    public static Source source(Path path, OpenOption ... options) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return IoKit.source(Files.newInputStream(path, options));
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return IoKit.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return IoKit.sink(new FileOutputStream(file, true));
    }

    public static Sink sink(Path path, OpenOption ... options) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return IoKit.sink(Files.newOutputStream(path, options));
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) throws IOException {
                source.skip(byteCount);
            }

            @Override
            public void flush() {
            }

            @Override
            public Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public void close() {
            }
        };
    }

    public static Source source(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        if (socket.getInputStream() == null) {
            throw new IOException("socket's input stream == null");
        }
        AsyncTimeout timeout = IoKit.timeout(socket);
        Source source = IoKit.source(socket.getInputStream(), timeout);
        return timeout.source(source);
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected IOException newTimeoutException(IOException cause) {
                SocketTimeoutException ioe = new SocketTimeoutException("timeout");
                if (cause != null) {
                    ioe.initCause(cause);
                }
                return ioe;
            }

            @Override
            protected void timedOut() {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new InstrumentException(e);
                }
                catch (AssertionError e) {
                    if (IoKit.isAndroidGetsocknameError(e)) {
                        throw new InstrumentException((Throwable)((Object)e));
                    }
                    throw e;
                }
            }
        };
    }

    static boolean isAndroidGetsocknameError(AssertionError e) {
        return ((Throwable)((Object)e)).getCause() != null && ((Throwable)((Object)e)).getMessage() != null && ((Throwable)((Object)e)).getMessage().contains("getsockname failed");
    }

    public static InputStream toInputStream(String input) {
        byte[] bytes = input.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream toInputStream(String input, String encoding) throws IOException {
        byte[] bytes = encoding != null ? input.getBytes(encoding) : input.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        IoKit.copy(input, (Writer)sw, encoding);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output) {
        InputStreamReader in = new InputStreamReader(input);
        IoKit.copy(in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IoKit.copy(input, output);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            IoKit.copy(in, output);
        }
    }

    public static String toString(Reader input) {
        StringWriter sw = new StringWriter();
        IoKit.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(byte[] input) {
        return new String(input);
    }

    public static String toString(byte[] input, String encoding) throws IOException {
        if (encoding == null) {
            return new String(input);
        }
        return new String(input, encoding);
    }
}

