/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.annotation.NotThreadSafe;
import org.aoju.bus.health.Builder;

@NotThreadSafe
public final class Config {
    private static final Properties CONFIG = Builder.readProperties("bus-health.properties");

    private Config() {
    }

    public static String get(String key, String def) {
        return CONFIG.getProperty(key, def);
    }

    public static int get(String key, int def) {
        String value = CONFIG.getProperty(key);
        return value == null ? def : Builder.parseIntOrDefault(value, def);
    }

    public static double get(String key, double def) {
        String value = CONFIG.getProperty(key);
        return value == null ? def : Builder.parseDoubleOrDefault(value, def);
    }

    public static boolean get(String key, boolean def) {
        String value = CONFIG.getProperty(key);
        return value == null ? def : Boolean.parseBoolean(value);
    }

    public static void set(String key, Object val) {
        if (val == null) {
            CONFIG.remove(key);
        } else {
            CONFIG.setProperty(key, val.toString());
        }
    }

    public static void remove(String key) {
        CONFIG.remove(key);
    }

    public static void clear() {
        CONFIG.clear();
    }

    public static void load(Properties properties) {
        CONFIG.putAll((Map<?, ?>)properties);
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropertyException(String property) {
            super("Invalid property: \"" + property + "\" = " + Config.get(property, null));
        }

        public PropertyException(String property, String message) {
            super("Invalid property \"" + property + "\": " + message);
        }
    }
}

