/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin.software;

import java.util.function.Supplier;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.OSThread;

public abstract class AbstractOSThread
implements OSThread {
    private final Supplier<Double> cumulativeCpuLoad = Memoize.memoize(this::queryCumulativeCpuLoad, Memoize.defaultExpiration());
    private final int owningProcessId;

    protected AbstractOSThread(int processId) {
        this.owningProcessId = processId;
    }

    @Override
    public int getOwningProcessId() {
        return this.owningProcessId;
    }

    @Override
    public double getThreadCpuLoadCumulative() {
        return this.cumulativeCpuLoad.get();
    }

    private double queryCumulativeCpuLoad() {
        return (double)this.getUpTime() > 0.0 ? (double)(this.getKernelTime() + this.getUserTime()) / (double)this.getUpTime() : 0.0;
    }

    @Override
    public double getThreadCpuLoadBetweenTicks(OSThread priorSnapshot) {
        if (priorSnapshot != null && this.owningProcessId == priorSnapshot.getOwningProcessId() && this.getThreadId() == priorSnapshot.getThreadId() && this.getUpTime() > priorSnapshot.getUpTime()) {
            return (double)(this.getUserTime() - priorSnapshot.getUserTime() + this.getKernelTime() - priorSnapshot.getKernelTime()) / (double)(this.getUpTime() - priorSnapshot.getUpTime());
        }
        return this.getThreadCpuLoadCumulative();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public long getStartMemoryAddress() {
        return 0L;
    }

    @Override
    public long getContextSwitches() {
        return 0L;
    }

    @Override
    public long getMinorFaults() {
        return 0L;
    }

    @Override
    public long getMajorFaults() {
        return 0L;
    }

    @Override
    public boolean updateAttributes() {
        return false;
    }

    public String toString() {
        return "OSThread [threadId=" + this.getThreadId() + ", owningProcessId=" + this.getOwningProcessId() + ", name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", kernelTime=" + this.getKernelTime() + ", userTime=" + this.getUserTime() + ", upTime=" + this.getUpTime() + ", startTime=" + this.getStartTime() + ", startMemoryAddress=0x" + String.format("%x", this.getStartMemoryAddress()) + ", contextSwitches=" + this.getContextSwitches() + ", minorFaults=" + this.getMinorFaults() + ", majorFaults=" + this.getMajorFaults() + "]";
    }
}

