/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.linux.drivers.CpuInfo;
import org.aoju.bus.health.linux.drivers.Devicetree;
import org.aoju.bus.health.linux.drivers.Dmidecode;
import org.aoju.bus.health.linux.drivers.Lshal;
import org.aoju.bus.health.linux.drivers.Lshw;
import org.aoju.bus.health.linux.drivers.Sysfs;
import org.aoju.bus.health.linux.hardware.LinuxBaseboard;
import org.aoju.bus.health.linux.hardware.LinuxFirmware;

@Immutable
final class LinuxComputerSystem
extends AbstractComputerSystem {
    private final Supplier<String> manufacturer = Memoize.memoize(LinuxComputerSystem::queryManufacturer);
    private final Supplier<String> model = Memoize.memoize(LinuxComputerSystem::queryModel);
    private final Supplier<String> serialNumber = Memoize.memoize(LinuxComputerSystem::querySerialNumber);
    private final Supplier<String> uuid = Memoize.memoize(LinuxComputerSystem::queryUUID);

    LinuxComputerSystem() {
    }

    private static String queryManufacturer() {
        String result = Sysfs.querySystemVendor();
        if (result == null && (result = CpuInfo.queryCpuManufacturer()) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryModel() {
        String result = Sysfs.queryProductModel();
        if (result == null && (result = Devicetree.queryModel()) == null && (result = Lshw.queryModel()) == null) {
            return "unknown";
        }
        return result;
    }

    private static String querySerialNumber() {
        String result = Sysfs.queryProductSerial();
        if (result == null && (result = Dmidecode.querySerialNumber()) == null && (result = Lshal.querySerialNumber()) == null && (result = Lshw.querySerialNumber()) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryUUID() {
        String result = null;
        result = Sysfs.queryUUID();
        if (result == null && (result = Dmidecode.queryUUID()) == null && (result = Lshal.queryUUID()) == null && (result = Lshw.queryUUID()) == null) {
            return "unknown";
        }
        return result;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public Firmware createFirmware() {
        return new LinuxFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new LinuxBaseboard();
    }

    @Override
    public String getHardwareUUID() {
        return this.uuid.get();
    }
}

