/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractNetworkIF;
import org.aoju.bus.health.builtin.hardware.NetworkIF;

@ThreadSafe
public final class LinuxNetworkIF
extends AbstractNetworkIF {
    private int ifType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;

    public LinuxNetworkIF(NetworkInterface netint) {
        super(netint);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        ArrayList<NetworkIF> ifList = new ArrayList<NetworkIF>();
        for (NetworkInterface ni : LinuxNetworkIF.getNetworkInterfaces(includeLocalInterfaces)) {
            ifList.add(new LinuxNetworkIF(ni));
        }
        return ifList;
    }

    @Override
    public int getIfType() {
        return this.ifType;
    }

    @Override
    public boolean isConnectorPresent() {
        return this.connectorPresent;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        try {
            File ifDir = new File(String.format("/sys/class/net/%s/statistics", this.getName()));
            if (!ifDir.isDirectory()) {
                return false;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        String ifTypePath = String.format("/sys/class/net/%s/type", this.getName());
        String carrierPath = String.format("/sys/class/net/%s/carrier", this.getName());
        String txBytesPath = String.format("/sys/class/net/%s/statistics/tx_bytes", this.getName());
        String rxBytesPath = String.format("/sys/class/net/%s/statistics/rx_bytes", this.getName());
        String txPacketsPath = String.format("/sys/class/net/%s/statistics/tx_packets", this.getName());
        String rxPacketsPath = String.format("/sys/class/net/%s/statistics/rx_packets", this.getName());
        String txErrorsPath = String.format("/sys/class/net/%s/statistics/tx_errors", this.getName());
        String rxErrorsPath = String.format("/sys/class/net/%s/statistics/rx_errors", this.getName());
        String collisionsPath = String.format("/sys/class/net/%s/statistics/collisions", this.getName());
        String rxDropsPath = String.format("/sys/class/net/%s/statistics/rx_dropped", this.getName());
        String ifSpeed = String.format("/sys/class/net/%s/speed", this.getName());
        this.timeStamp = System.currentTimeMillis();
        this.ifType = Builder.getIntFromFile(ifTypePath);
        this.connectorPresent = Builder.getIntFromFile(carrierPath) > 0;
        this.bytesSent = Builder.getLongFromFile(txBytesPath);
        this.bytesRecv = Builder.getLongFromFile(rxBytesPath);
        this.packetsSent = Builder.getLongFromFile(txPacketsPath);
        this.packetsRecv = Builder.getLongFromFile(rxPacketsPath);
        this.outErrors = Builder.getLongFromFile(txErrorsPath);
        this.inErrors = Builder.getLongFromFile(rxErrorsPath);
        this.collisions = Builder.getLongFromFile(collisionsPath);
        this.inDrops = Builder.getLongFromFile(rxDropsPath);
        long speedMiB = Builder.getLongFromFile(ifSpeed);
        this.speed = speedMiB < 0L ? 0L : speedMiB << 20;
        return true;
    }
}

