/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quartet;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.mac.hardware.MacBaseboard;
import org.aoju.bus.health.mac.hardware.MacFirmware;

@Immutable
final class MacComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Quartet<String, String, String, String>> manufacturerModelSerialUUID = Memoize.memoize(MacComputerSystem::platformExpert);

    MacComputerSystem() {
    }

    private static Quartet<String, String, String, String> platformExpert() {
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        String uuid = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("model")) != null) {
                model = Native.toString((byte[])data, (Charset)StandardCharsets.UTF_8);
            }
            serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            uuid = platformExpert.getStringProperty("IOPlatformUUID");
            platformExpert.release();
        }
        return new Quartet<String, String, String, String>(StringKit.isBlank(manufacturer) ? "Apple Inc." : manufacturer, StringKit.isBlank(model) ? "unknown" : model, StringKit.isBlank(serialNumber) ? "unknown" : serialNumber, StringKit.isBlank(uuid) ? "unknown" : uuid);
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerModelSerialUUID.get().getA();
    }

    @Override
    public String getModel() {
        return this.manufacturerModelSerialUUID.get().getB();
    }

    @Override
    public String getSerialNumber() {
        return this.manufacturerModelSerialUUID.get().getC();
    }

    @Override
    public String getHardwareUUID() {
        return this.manufacturerModelSerialUUID.get().getD();
    }

    @Override
    public Firmware createFirmware() {
        return new MacFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new MacBaseboard();
    }
}

