/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.unix.aix.hardware.AixBaseboard;
import org.aoju.bus.health.unix.aix.hardware.AixFirmware;

@Immutable
final class AixComputerSystem
extends AbstractComputerSystem {
    private final Supplier<LsattrStrings> lsattrStrings = Memoize.memoize(AixComputerSystem::readLsattr);
    private final Supplier<List<String>> lscfg;

    AixComputerSystem(Supplier<List<String>> lscfg) {
        this.lscfg = lscfg;
    }

    private static LsattrStrings readLsattr() {
        String fwVendor = "IBM";
        String fwVersion = null;
        String fwPlatformVersion = null;
        String manufacturer = fwVendor;
        String model = null;
        String serialNumber = null;
        String uuid = null;
        String fwVersionMarker = "fwversion";
        String modelMarker = "modelname";
        String systemIdMarker = "systemid";
        String uuidMarker = "os_uuid";
        String fwPlatformVersionMarker = "Platform Firmware level is";
        for (String checkLine : Executor.runNative("lsattr -El sys0")) {
            int comma;
            if (checkLine.startsWith("fwversion")) {
                fwVersion = checkLine.split("fwversion")[1].trim();
                comma = fwVersion.indexOf(44);
                if (comma > 0 && fwVersion.length() > comma) {
                    fwVendor = fwVersion.substring(0, comma);
                    fwVersion = fwVersion.substring(comma + 1);
                }
                fwVersion = RegEx.SPACES.split(fwVersion)[0];
                continue;
            }
            if (checkLine.startsWith("modelname")) {
                model = checkLine.split("modelname")[1].trim();
                comma = model.indexOf(44);
                if (comma > 0 && model.length() > comma) {
                    manufacturer = model.substring(0, comma);
                    model = model.substring(comma + 1);
                }
                model = RegEx.SPACES.split(model)[0];
                continue;
            }
            if (!checkLine.startsWith("systemid")) continue;
            uuid = checkLine.split("os_uuid")[1].trim();
            uuid = RegEx.SPACES.split(uuid)[0];
        }
        for (String checkLine : Executor.runNative("lsmcode -c")) {
            if (!checkLine.startsWith("Platform Firmware level is")) continue;
            fwPlatformVersion = checkLine.split("Platform Firmware level is")[1].trim();
            break;
        }
        return new LsattrStrings(fwVendor, fwPlatformVersion, fwVersion, manufacturer, model, serialNumber, uuid);
    }

    @Override
    public String getManufacturer() {
        return this.lsattrStrings.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.lsattrStrings.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.lsattrStrings.get().serialNumber;
    }

    @Override
    public String getHardwareUUID() {
        return this.lsattrStrings.get().uuid;
    }

    @Override
    public Firmware createFirmware() {
        return new AixFirmware(this.lsattrStrings.get().biosVendor, this.lsattrStrings.get().biosPlatformVersion, this.lsattrStrings.get().biosVersion);
    }

    @Override
    public Baseboard createBaseboard() {
        return new AixBaseboard(this.lscfg);
    }

    private static final class LsattrStrings {
        private final String biosVendor;
        private final String biosPlatformVersion;
        private final String biosVersion;
        private final String manufacturer;
        private final String model;
        private final String serialNumber;
        private final String uuid;

        private LsattrStrings(String biosVendor, String biosPlatformVersion, String biosVersion, String manufacturer, String model, String serialNumber, String uuid) {
            this.biosVendor = StringKit.isBlank(biosVendor) ? "unknown" : biosVendor;
            this.biosPlatformVersion = StringKit.isBlank(biosPlatformVersion) ? "unknown" : biosPlatformVersion;
            this.biosVersion = StringKit.isBlank(biosVersion) ? "unknown" : biosVersion;
            this.manufacturer = StringKit.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = StringKit.isBlank(model) ? "unknown" : model;
            this.serialNumber = StringKit.isBlank(serialNumber) ? "unknown" : serialNumber;
            this.uuid = StringKit.isBlank(uuid) ? "unknown" : uuid;
        }
    }
}

