/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractHWDiskStore;
import org.aoju.bus.health.builtin.hardware.HWDiskStore;
import org.aoju.bus.health.builtin.hardware.HWPartition;
import org.aoju.bus.health.unix.freebsd.BsdSysctlKit;
import org.aoju.bus.health.unix.freebsd.drivers.GeomDiskList;
import org.aoju.bus.health.unix.freebsd.drivers.GeomPartList;

@ThreadSafe
public final class FreeBsdHWDiskStore
extends AbstractHWDiskStore {
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList;

    private FreeBsdHWDiskStore(String name, String model, String serial, long size) {
        super(name, model, serial, size);
    }

    public static List<HWDiskStore> getDisks() {
        ArrayList<HWDiskStore> diskList = new ArrayList<HWDiskStore>();
        Map<String, List<HWPartition>> partitionMap = GeomPartList.queryPartitions();
        Map<String, Triple<String, String, Long>> diskInfoMap = GeomDiskList.queryDisks();
        List<String> devices = Arrays.asList(RegEx.SPACES.split(BsdSysctlKit.sysctl("kern.disks", "")));
        List<String> iostat = Executor.runNative("iostat -Ix");
        long now = System.currentTimeMillis();
        for (String line : iostat) {
            String[] split = RegEx.SPACES.split(line);
            if (split.length <= 6 || !devices.contains(split[0])) continue;
            Triple<String, String, Long> storeInfo = diskInfoMap.get(split[0]);
            FreeBsdHWDiskStore store = storeInfo == null ? new FreeBsdHWDiskStore(split[0], "unknown", "unknown", 0L) : new FreeBsdHWDiskStore(split[0], storeInfo.getLeft(), storeInfo.getMiddle(), storeInfo.getRight());
            store.reads = (long)Builder.parseDoubleOrDefault(split[1], 0.0);
            store.writes = (long)Builder.parseDoubleOrDefault(split[2], 0.0);
            store.readBytes = (long)(Builder.parseDoubleOrDefault(split[3], 0.0) * 1024.0);
            store.writeBytes = (long)(Builder.parseDoubleOrDefault(split[4], 0.0) * 1024.0);
            store.currentQueueLength = Builder.parseLongOrDefault(split[5], 0L);
            store.transferTime = (long)(Builder.parseDoubleOrDefault(split[6], 0.0) * 1000.0);
            store.partitionList = Collections.unmodifiableList(partitionMap.getOrDefault(split[0], Collections.emptyList()).stream().sorted(Comparator.comparing(HWPartition::getName)).collect(Collectors.toList()));
            store.timeStamp = now;
            diskList.add(store);
        }
        return diskList;
    }

    @Override
    public long getReads() {
        return this.reads;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrites() {
        return this.writes;
    }

    @Override
    public long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    @Override
    public boolean updateAttributes() {
        List<String> output = Executor.runNative("iostat -Ix " + this.getName());
        long now = System.currentTimeMillis();
        boolean diskFound = false;
        for (String line : output) {
            String[] split = RegEx.SPACES.split(line);
            if (split.length < 7 || !split[0].equals(this.getName())) continue;
            diskFound = true;
            this.reads = (long)Builder.parseDoubleOrDefault(split[1], 0.0);
            this.writes = (long)Builder.parseDoubleOrDefault(split[2], 0.0);
            this.readBytes = (long)(Builder.parseDoubleOrDefault(split[3], 0.0) * 1024.0);
            this.writeBytes = (long)(Builder.parseDoubleOrDefault(split[4], 0.0) * 1024.0);
            this.currentQueueLength = Builder.parseLongOrDefault(split[5], 0L);
            this.transferTime = (long)(Builder.parseDoubleOrDefault(split[6], 0.0) * 1000.0);
            this.timeStamp = now;
        }
        return diskFound;
    }
}

