/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractSensors;
import org.aoju.bus.health.unix.freebsd.FreeBsdLibc;

@ThreadSafe
final class FreeBsdSensors
extends AbstractSensors {
    FreeBsdSensors() {
    }

    private static double queryKldloadCoretemp() {
        String name = "dev.cpu.%d.temperature";
        IntByReference size = new IntByReference(FreeBsdLibc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        int cpu = 0;
        double sumTemp = 0.0;
        while (0 == FreeBsdLibc.INSTANCE.sysctlbyname(String.format(name, cpu), (Pointer)p, size, null, 0)) {
            sumTemp += (double)p.getInt(0L) / 10.0 - 273.15;
            ++cpu;
        }
        return cpu > 0 ? sumTemp / (double)cpu : Double.NaN;
    }

    @Override
    public double queryCpuTemperature() {
        return FreeBsdSensors.queryKldloadCoretemp();
    }

    @Override
    public int[] queryFanSpeeds() {
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        return 0.0;
    }
}

