/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class FstatKit {
    private FstatKit() {
    }

    public static String getCwd(int pid) {
        List<String> ps = Executor.runNative("ps -axwwo cwd -p " + pid);
        if (!ps.isEmpty()) {
            return ps.get(1);
        }
        return "";
    }

    public static long getOpenFiles(int pid) {
        long fd = 0L;
        List<String> fstat = Executor.runNative("fstat -sp " + pid);
        for (String line : fstat) {
            String[] split = RegEx.SPACES.split(line.trim(), 11);
            if (split.length != 11 || "pipe".contains(split[4]) || "unix".contains(split[4])) continue;
            ++fd;
        }
        return fd - 1L;
    }
}

