/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.unix.openbsd.OpenBsdLibc;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class OpenBsdSysctlKit {
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private OpenBsdSysctlKit() {
    }

    public static int sysctl(int[] name, int def) {
        IntByReference size = new IntByReference(OpenBsdLibc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, size, null, 0)) {
            Logger.error(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        return p.getInt(0L);
    }

    public static long sysctl(int[] name, long def) {
        IntByReference size = new IntByReference(OpenBsdLibc.UINT64_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, size, null, 0)) {
            Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        return p.getLong(0L);
    }

    public static String sysctl(int[] name, String def) {
        IntByReference size = new IntByReference();
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, 0)) {
            Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        Memory p = new Memory((long)size.getValue() + 1L);
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)p, size, null, 0)) {
            Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        return p.getString(0L);
    }

    public static boolean sysctl(int[] name, Structure struct) {
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, struct.getPointer(), new IntByReference(struct.size()), null, 0)) {
            Logger.error(SYSCTL_FAIL, name, Native.getLastError());
            return false;
        }
        struct.read();
        return true;
    }

    public static Memory sysctl(int[] name) {
        IntByReference size = new IntByReference();
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, null, size, null, 0)) {
            Logger.error(SYSCTL_FAIL, name, Native.getLastError());
            return null;
        }
        Memory m = new Memory((long)size.getValue());
        if (0 != OpenBsdLibc.INSTANCE.sysctl(name, name.length, (Pointer)m, size, null, 0)) {
            Logger.error(SYSCTL_FAIL, name, Native.getLastError());
            return null;
        }
        return m;
    }

    public static int sysctl(String name, int def) {
        return Builder.parseIntOrDefault(Executor.getFirstAnswer("sysctl -n " + name), def);
    }

    public static long sysctl(String name, long def) {
        return Builder.parseLongOrDefault(Executor.getFirstAnswer("sysctl -n " + name), def);
    }

    public static String sysctl(String name, String def) {
        String v = Executor.getFirstAnswer("sysctl -n " + name);
        if (null == v || v.isEmpty()) {
            return def;
        }
        return v;
    }
}

